/*
 * TrkBetaPrVsTofBetaHistoAction.cpp
 *
 *  Created on: 2009-06-05
 *      Author: S. Ricciarini
 */

/*! @file TrkBetaPrVsTofBetaHistoAction.cpp The TrkBetaPrVsTofBetaHistoAction class implementation file. */

#include "TrkBetaPrVsTofBetaHistoAction.h"

TrkBetaPrVsTofBetaHistoAction::TrkBetaPrVsTofBetaHistoAction(const char *actionName, TString outFileName, TString mode) :
  CollectionAction(actionName), _outFileName(outFileName), _histo(), _mode(mode) {
  
  _histo.SetName(GetName());
  _histo.SetTitle("TRK Beta (p) Vs. TOF Beta");
  _histo.GetXaxis()->SetTitle("TOF Beta");
  _histo.GetYaxis()->SetTitle("TRK Beta (p)");
  _histo.SetBins(500, 0., 1.2, 500, 0., 1.2);
}

void TrkBetaPrVsTofBetaHistoAction::OnGood(PamLevel2 *event){

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();
    
  Int_t seqno = trkTrack->GetSeqNo();
  Int_t ntrack_tof = 0;
  for (Int_t i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == seqno)
      ntrack_tof = i;
  }
  Float_t betaModTof = fabs(event->GetToFLevel2()->CalcBeta(ntrack_tof, 10., 10., 20.)); // beta[12] for TRK track 0
 
  Int_t _charge=1;
  Float_t _mass_p=0.93827203; // GeV (pdg.web.cern.ch)
 
  Float_t betaModTrk_p = (trkTrack->GetRigidity() * abs(_charge)) / pow(pow(trkTrack->GetRigidity() * _charge, 2) + pow(_mass_p, 2), 0.5);

  _histo.Fill(betaModTof,betaModTrk_p);

}

void TrkBetaPrVsTofBetaHistoAction::Finalize(){

  TFile outFile(_outFileName, _mode);
  outFile.cd();
  _histo.Write();
  outFile.Close();

}
