/*
 * TofBetaRigHeCut.cpp
 *
 *  Created on: 14/set/2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaRigHeCut.cpp The TofBetaRigHeCut class implementation file */

#include "TofBetaRigHeCut.h"

int TofBetaRigHeCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  Int_t seqno = trkTrack->GetSeqNo();
  Int_t ntrack_tof = 0;
  for (Int_t i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == seqno)
      ntrack_tof = i;
  }
  Float_t tofBeta = fabs(event->GetToFLevel2()->CalcBeta(ntrack_tof, 10., 10., 20.)); // beta[12]

  //  Float_t rigMod = _mass*fabs(beta)*pow((1-pow(beta,2)),-0.5)/abs(_charge);

  Int_t _charge = 2;
  Float_t mass_4He = 3.7274; // GeV (http://hyperphysics.phy-astr.gsu.edu/Hbase/pertab/He.html)
  Float_t mass_3He = 2.8084; // GeV (http://hyperphysics.phy-astr.gsu.edu/Hbase/pertab/He.html)
  Float_t ZR2 = (trkTrack->GetRigidity() * _charge) * (trkTrack->GetRigidity() * _charge);

  Float_t trkBeta_4He = sqrt(ZR2 / (ZR2 + mass_4He * mass_4He));

  Float_t trkBeta_3He = sqrt(ZR2 / (ZR2 + mass_3He * mass_3He));

  if ((fabs(tofBeta - trkBeta_4He) > _threshold * tofBeta) && (fabs(tofBeta - trkBeta_3He) > _threshold * tofBeta)) {
    return 0;
  }

  return CUTOK;
}
