/*
 * TrackRedGeomCut.h
 *
 *  Created on: 30-nov-2009
 *      Author: S. Ricciarini
 */

/*! @file TrackRedGeomCut.h The TrackRedGeomCut class definition file */

#ifndef TRACKREDGEOMCUT_H_
#define TRACKREDGEOMCUT_H_

#include "../../PamCutBase/PamCutBase.h"
#include "../../CaloAxis2.h"

/*! @brief The track reduced acceptance (i.e. rectangular pipe) cut.
 * This cut checks if the track is inside the reduced acceptance chosen.
 * The check can be done using either the tracker's track or CaloAxis track.
 * CUT DEPENDENCIES: objects pamTrack, xCaloAxis, yCaloAxis.
 */

class TrackRedGeomCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * The parameters are the X and Y lengths of the rectangular pipe define the reduced acceptance region (centered on PAMELA vertical central axis).
   *
   * @param cutName The cut's name.
   * @param pamTrack The pointer to *pamTrack object
   * @param xDim The X-side length in cm.
   * @param yDim The Y-side length in cm.
   */
  TrackRedGeomCut(const char *cutName, PamTrack **pamTrack, float xDim, float yDim) :
    PamCut(cutName), _pamTrack(pamTrack), _xCaloAxis(NULL), _yCaloAxis(NULL), _xDim(xDim), _yDim(yDim) {
  }

  /*! @brief Constructor.
   *
   * The CaloAxis arguments are pointers to objects which contain the CaloAxis calorimeter
   * track information for current event.
   *
   * @param cutName The cut's name.
   * @param xCaloAxis The pointer to the CaloAxis object for X axis.
   * @param yCaloAxis The pointer to the CaloAxis object for Y axis.
   * @param xDim The X-side length in cm.
   * @param yDim The Y-side length in cm.
   */
  TrackRedGeomCut(const char *cutName, CaloAxis *xCaloAxis, CaloAxis *yCaloAxis, float xDim, float yDim) :
    PamCut(cutName), _pamTrack(NULL), _xCaloAxis(xCaloAxis), _yCaloAxis(yCaloAxis), _xDim(xDim), _yDim(yDim) {
  }

  /*! @brief Destructor. */
  ~TrackRedGeomCut() {
  }

  /*! @brief The track reduced acceptance check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the track is inside the reduced acceptance.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  PamTrack **_pamTrack;
  CaloAxis *_xCaloAxis, *_yCaloAxis;
  float _xDim;
  float _yDim;

};
#endif /* TRACKREDGEOMCUT_H_ */
