/*
 * StoermerCut.h
 *
 *  Created on: 10-jun-2009
 *      Author: Nicola Mori
 */

/*! @file StoermerCut.h The StoermerCut class definition file */

#ifndef STOERMERCUT_H_
#define STOERMERCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The Stoermer cutoff cut.
 *
 * This cut discards all events whose Stormer cutoff is outside the desired interval.
 *
 */
class StoermerCut: public PamCut {
public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param minR The lower threshold value of the Stoermer cutoff, in GV.
   * @param maxR The upper threshold value of the Stoermer cutoff, in GV.
   */
  StoermerCut(const char *cutName, Float_t minR, Float_t maxR) :
    PamCut(cutName), _minR(minR), _maxR(maxR) {
  }

  /*! @brief Destructor. */
  ~StoermerCut() {
  }

  /*! @brief Apply the Stoermer cutoff cut.
   *
   * @param event The event to analyze.
   * @return CUTOK if minB < Stoermer cutoff < maxR.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:
  float _minR, _maxR;

};

#endif /* STOERMERCUT_H_ */
