/*
 * PktQualCut.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Sergio Riciarini, Nicola Mori
 */

/*! @file PktQualCut.cpp The PktQualCut class implementation file */

#include "PktQualCut.h"

int PktQualCut::Check(PamLevel2 *event) {

  // Check run
  if (event->GetRunInfo()->ID != _previousRun){
    _previousRun = event->GetRunInfo()->ID;
    _previousPkt = event->GetOrbitalInfo()->pkt_num;
//    return PKT_NEWRUN;
	return CUTOK;
  }

  // Check packet number
  if (event->GetOrbitalInfo()->pkt_num <= _previousPkt){
    return PKT_INVALID;
  }

  // The packet number is good
  _previousPkt = event->GetOrbitalInfo()->pkt_num;
  return CUTOK;

}
