/*
 * OBTQualCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file OBTQualCut.h The OBTQualCut class definition file */

#ifndef OBTQUALCUT_H_
#define OBTQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @enum OBT_Return Return values for rejected events */
enum OBT_Return {
  OBT_NEWRUN, ///< Discarded because it is the first event of the run.
  OBT_INVALID ///< Discarded because the OBT is not valid.
};

using std::numeric_limits;
/*! @brief The On Board Time quality cut.
 *
 * This cut rejects events whose OBT is less than that of the previous event.
 * When a new run starts, the previous OBT is set to the current one and the
 * current event (ie., the first event of the run) is discarded.
 */
class OBTQualCut: public PamCut {

public:
  /*! @brief Constructor. */
  OBTQualCut(const char *cutName) :
    PamCut(cutName), _previousOBT(numeric_limits<UInt_t>::max()), _previousRun(numeric_limits<UInt_t>::max()) {
  }
  /*! @brief Destructor. */
  ~OBTQualCut() {
  }

  /*! @brief The On Board Time quality check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if OBT > previous OBT.
   * @return #OBT_NEWRUN if the event has been discarded since it is the first of the run
   * @return #OBT_INVALID if OBT < previous OBT
   */
  int Check(PamLevel2 *event);

private:
  UInt_t _previousOBT;
  UInt_t _previousRun;

};

#endif /* OBTQUALCUT_H_ */
