/*
 * TrkYVsXHistoAction.h
 *
 *  Created on: 02/dec/2009
 *      Author: Sergio Ricciarini
 */

/*! @file TrkYVsXHistoAction.h The TrkYVsXHistoAction class declaration file. */

#ifndef TRKYVSXHISTOACTION_H_
#define TRKYVSXHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a TRK Y vs. X histogram for track 0 over acceptance planes ipl.
 *
 */
class TrkYVsXHistoAction: public Histo2DAction<Int_t> {

public:

   /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   * @param igf The acceptance plane (index goes from 0 to 13). Default: 4 (upper cavity face)
   */
  TrkYVsXHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE",
      bool outRoot = true, bool outText = true, TString title = "TRK Y Vs X", UInt_t igf = 4);


  /*! @brief Destructor */
  ~TrkYVsXHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:
  UInt_t _igf;

};

#endif /* TRKYVSXHISTOACTION_H_ */
