/*
 * ChargeHistosAction.cpp
 *
 *  Created on: 17-mag-2009
 *      Author: Nicola Mori
 */

/*! @file ChargeHistosAction.cpp The ChargeHistosAction class implementation file */

#include "ChargeHistosAction.h"

ChargeHistosAction::ChargeHistosAction(const char *actionName, TString outFileName, TString mode) :
  CollectionAction(actionName),
#ifndef NO_TOFNUCLEI
  _tofNuclei(NULL),
  _chargeS11("chargeS11", "Charge S11", 100, 0., 4.),
  _chargeS12("chargeS12", "Charge S12", 100, 0., 4.),
  _chargeS21("chargeS21", "Charge S21", 100, 0., 4.),
  _chargeS22("chargeS22", "Charge S22", 100, 0., 4.),
  _chargeS31("chargeS31", "Charge S31", 100, 0., 4.),
  _chargeS32("chargeS32", "Charge S32", 100, 0., 4.),
  _chCorrS11S12("chCorrS11S12", "Z(S11) vs Z(s12)", 100, 0., 4., 100, 0., 4.),
  _chCorrS11S21("chCorrS11S21", "Z(S11) vs Z(s21)", 100, 0., 4., 100, 0., 4.),
  _chCorrS11S22("chCorrS11S22", "Z(S11) vs Z(s22)", 100, 0., 4., 100, 0., 4.),
  _chCorrS11S31("chCorrS11S31", "Z(S11) vs Z(s31)", 100, 0., 4., 100, 0., 4.),
  _chCorrS11S32("chCorrS11S32", "Z(S11) vs Z(s32)", 100, 0., 4., 100, 0., 4.),
  _chCorrS12S21("chCorrS12S21", "Z(S12) vs Z(s21)", 100, 0., 4., 100, 0., 4.),
  _chCorrS12S22("chCorrS12S22", "Z(S12) vs Z(s22)", 100, 0., 4., 100, 0., 4.),
  _chCorrS12S31("chCorrS12S31", "Z(S12) vs Z(s31)", 100, 0., 4., 100, 0., 4.),
  _chCorrS12S32("chCorrS12S32", "Z(S12) vs Z(s32)", 100, 0., 4., 100, 0., 4.),
  _chCorrS21S22("chCorrS21S22", "Z(S21) vs Z(s22)", 100, 0., 4., 100, 0., 4.),
  _chCorrS21S31("chCorrS21S31", "Z(S21) vs Z(s31)", 100, 0., 4., 100, 0., 4.),
  _chCorrS21S32("chCorr212S32", "Z(S21) vs Z(s32)", 100, 0., 4., 100, 0., 4.),
  _chCorrS22S31("chCorrS22S31", "Z(S22) vs Z(s31)", 100, 0., 4., 100, 0., 4.),
  _chCorrS22S32("chCorrS22S32", "Z(S22) vs Z(s32)", 100, 0., 4., 100, 0., 4.),
  _chCorrS31S32("chCorrS31S32", "Z(S31) vs Z(s32)", 100, 0., 4., 100, 0., 4.),
#endif
#ifndef NO_CALONUCLEI
  _caloNuclei(NULL),
  _chargeCalo("chargeCalo", "Charge Calo", 100, 0., 4.),
#endif
#ifndef NO_TRKNUCLEI
  _trkNuclei(NULL),
  _chargeTrk("chargeTrk", "Charge Trk", 100, 0., 4.),
#endif
  _outFileName(outFileName), _mode(mode) {
}


ChargeHistosAction::~ChargeHistosAction(){
#ifndef NO_TOFNUCLEI
  delete _tofNuclei;
  _tofNuclei = NULL;
#endif

#ifndef NO_CALONUCLEI
  delete _caloNuclei;
  _caloNuclei = NULL;
#endif

#ifndef NO_TRKNUCLEI
  delete _trkNuclei;
  _trkNuclei = NULL;
#endif
}



void ChargeHistosAction::OnGood(PamLevel2 *event) {

#ifndef NO_TOFNUCLEI
  if (_tofNuclei == NULL)
    _tofNuclei = new ToFNuclei(event);

  Float_t *charge = _tofNuclei->Get_Charge_ToF_std_layer();

  _chargeS11.Fill(charge[0]);
  _chargeS12.Fill(charge[1]);
  _chargeS21.Fill(charge[2]);
  _chargeS22.Fill(charge[3]);
  _chargeS31.Fill(charge[4]);
  _chargeS32.Fill(charge[5]);

  _chCorrS11S12.Fill(charge[1], charge[0]);
  _chCorrS11S21.Fill(charge[2], charge[0]);
  _chCorrS11S22.Fill(charge[3], charge[0]);
  _chCorrS11S31.Fill(charge[4], charge[0]);
  _chCorrS11S32.Fill(charge[5], charge[0]);
  _chCorrS12S21.Fill(charge[2], charge[1]);
  _chCorrS12S22.Fill(charge[3], charge[1]);
  _chCorrS12S31.Fill(charge[4], charge[1]);
  _chCorrS12S32.Fill(charge[5], charge[1]);
  _chCorrS21S22.Fill(charge[3], charge[2]);
  _chCorrS21S31.Fill(charge[4], charge[2]);
  _chCorrS21S32.Fill(charge[5], charge[2]);
  _chCorrS22S31.Fill(charge[4], charge[3]);
  _chCorrS22S32.Fill(charge[5], charge[3]);
  _chCorrS31S32.Fill(charge[5], charge[4]);
#endif

#ifndef NO_CALONUCLEI
  if (_caloNuclei == NULL)
    _caloNuclei = new CaloNuclei(event);
  _chargeCalo.Fill(_caloNuclei->Get_charge_siegen1());
#endif

#ifndef NO_TRKNUCLEI
  if (_trkNuclei == NULL)
    _trkNuclei = new TrkNuclei();
  _trkNuclei->Set(event->GetTrack(0)->GetTrkTrack());
  _chargeTrk.Fill(_trkNuclei->GetZ_Rigidity());
#endif

}

void ChargeHistosAction::Finalize() {
  TFile outFile(_outFileName, _mode);
  outFile.cd();

#ifndef NO_TOFNUCLEI
  _chargeS11.Write();
  _chargeS12.Write();
  _chargeS21.Write();
  _chargeS22.Write();
  _chargeS31.Write();
  _chargeS32.Write();

  _chCorrS11S12.Write();
  _chCorrS11S21.Write();
  _chCorrS11S22.Write();
  _chCorrS11S31.Write();
  _chCorrS11S32.Write();
  _chCorrS12S21.Write();
  _chCorrS12S22.Write();
  _chCorrS12S31.Write();
  _chCorrS12S32.Write();
  _chCorrS21S22.Write();
  _chCorrS21S31.Write();
  _chCorrS21S32.Write();
  _chCorrS22S31.Write();
  _chCorrS22S32.Write();
  _chCorrS31S32.Write();
#endif

#ifndef NO_CALONUCLEI
  _chargeCalo.Write();
#endif

#ifndef NO_TRKNUCLEI
  _chargeTrk.Write();
#endif

  outFile.Close();

}
