/*
 * TofBetaRigHeCut.h
 *
 *  Created on: 14/set/2009
 *      Author: S. Ricciarini, N. Mori
 */

/*! @file TofBetaRigHeCut.h The TofBetaRigHeCut class definition file */

#ifndef TOFBETARIGHECUT_H_
#define TOFBETARIGHECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The match between TOF beta modulus and TRK beta modulus for 4He and 3He
 * This cut discards all the events for which the absolute RELATIVE difference between TRK beta
 * modulus (calculated from rigidity of TRK track, mass M=4 OR 3 and charge Z=2) and TOF beta
 * modulus is greater than the threshold.
 * Rigidity is defined as p/Z (GV) where Z is the particle charge and p the momentum modulus.
 */
class TofBetaRigHeCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param threshold The relative rigidity-difference threshold.
   */
  TofBetaRigHeCut(const char *cutName, float threshold) :
    PamCut(cutName), _threshold(threshold) {

  }
  /*! @brief Destructor. */
  ~TofBetaRigHeCut() {

  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the beta difference is less than the threshold
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _threshold;

};
#endif /* TOFBETARIGHECUT_H_ */
