/*
 * VerboseCollection.h
 *
 *  Created on: 16-mag-2009
 *      Author: Nicola Mori
 */

/*! @file VerboseCollection.h The VerboseCollection class definition file */

#ifndef VERBOSECOLLECTION_H_
#define VERBOSECOLLECTION_H_

#include "../SmartCollection/SmartCollection.h"
/*! @brief A smart collection which prints selection reports.
 *
 * This class inherits from SmartCollection, so it can handle actions. It is designed to
 * automate a very common task: printing the selection results at the end of the analysis.
 * Other desired tasks can be accomplished by means of actions.
 */
class VerboseCollection: public SmartCollection {

public:

  /*! @brief Constructor.
   *
   * @param collectionName The collection's name.
   * @param owns If true, the collection will own the cuts and the actions, ie., it will
   *             destroy them in its destructor.
   */
  VerboseCollection(const char *collectionName, bool owns = true) :
    SmartCollection(collectionName, owns) {
  }

  /*! @brief Destructor. */
  ~VerboseCollection() {
  }

  /*! @brief The post analysis task.
   *
   * This implementation simply prints the selection report, and then calls
   * SmartColletion::Finalize().
   */
  void Finalize();

};

#endif /* VERBOSECOLLECTION_H_ */
