/*
 * CaloQtotHistoAction.h
 *
 *  Created on: 2010-03-12
 *      Author: S. Ricciarini
 */

/*! @file CaloQtotHistoAction.h The CaloQtotHistoAction class declaration file. */

#ifndef CALOQTOTHISTOACTION_H_
#define CALOQTOTHISTOACTION_H_

#include "../Histo1DAction/Histo1DAction.h"

/*! @brief An action that fills the histogram: Calo Qtot.
 */
class CaloQtotHistoAction: public Histo1DAction<Double_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   * @param outRoot If true, the output file in ROOT format will be produced.
   * @param outText If true, the output file in text format will be produced.
   *             in ROOT's reference guide).
   * @param title The ROOT histogram title.
   */
  CaloQtotHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot = true,
      bool outText = true, TString title = "Qtot");

  /*! @brief Destructor */
  ~CaloQtotHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

};

#endif /* CALOQTOTHISTOACTION_H_ */
