/*
 * EvRateCorrHistoAction.h
 *
 *  Created on: 15-giu-2009
 *      Author: mori
 */

/*! @file EvRateCorrHistoAction.h The EvRateCorrHistoAction class declaration file. */

#ifndef EVRATECORRHISTOACTION_H_
#define EVRATECORRHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>

/*! @brief An action that fills an (event rate on S11) Vs. (event rate on S12) 2D histogram.
 *
 * The event rate on S11 (S12) is the mean of the event rates on each PMT of S11 (S12).
 */
class EvRateCorrHistoAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param mode The mode of file creation (see documentation of TFile constructor
   *             in ROOT's reference guide)
   */
  EvRateCorrHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE");

  /*! @brief Destructor */
  ~EvRateCorrHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output file. */
  void Finalize();

private:

  TString _outFileName;
  TH2F _histo;
  TString _mode;

};
#endif /* EVRATECORRHISTOACTION_H_ */
