/*
 * TrkPhSinCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TrkPhSinCut.cpp The TrkPhSinCut class implementation file */

#include "TrkPhSinCut.h"

int TrkPhSinCut::Check(PamLevel2 *event) {

  if (!(event->GetTrkLevel2()->GetNTracks() == 1))
    return 0; // one track exists (physical or not)

  // selection of the physical track (see TrkId below)
  event->SetSortingMethod(_sortingMethod);
  pamTrack = event->GetTrack(0);

  // NOTE: pamtrack is null pointer if no physical track is selected; this is a redundant check to find bugs in the level2 (at least one physical track should always be present, given that GetNTracks()=1 according to the previous cut).
  if (!pamTrack)
    return 0; // redundant check

  trkTrack = pamTrack->GetTrkTrack();

  // Check if good clusters have meaningful energy releases
  for (unsigned int ip = 0; ip < 6; ip++) {
    if (trkTrack->XGood(ip) == 1 && trkTrack->GetDEDX(ip, 0) <= 0.)
      trkTrack->xgood[ip] = 0; // Set it to bad
    if (trkTrack->YGood(ip) == 1 && trkTrack->GetDEDX(ip, 1) <= 0.)
      trkTrack->ygood[ip] = 0; // Set it to bad
  }

  if (!(trkTrack->nstep < 100 && trkTrack->chi2 > 0.))
    return 0; // check that the track is meaningful

  // identification of TRK-track TOF-index (this index is generally different from TRK-track TRK-index)
  iTrackTof = -1000;
  for (int i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == trkTrack->GetSeqNo()) {
      iTrackTof = i;
      break;
    }
  }

  return CUTOK;

}
