/*
 * TofBetaRangeCut.h
 *
 *  Created on: 10-apr-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TofBetaRangeCut.h The TofBetaRangeCut class definition file */

#ifndef TOFBETARANGECUT_H_
#define TOFBETARANGECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The TofBetaRange cut.
 * This cut selects a range of beta values. Note that beta can be either positive (downward going particle) or negative (upward going particle).
 */

class TofBetaRangeCut: public PamCut {

public:
  /*! @brief Constructor.
   * The parameters are: the TOF-index for the track which is necessary to input to derive the beta; resMax, qualCut and chi2Cut for the quality of beta; the minimum and maximum beta values.
   * Various combinations of quality parameters are possible: default low-quality beta (used for beta[12]): 10.,10.,20.; medium-quality beta: 5.,15.,4.; high-quality beta: 3.,20.,3.
   * NOTE: beta can be either positive (downward going particle) or negative (upward going particle). Beta = 100 means beta calculation was not successful.

   * @param cutName The cut's name.
   * @param trackTof Pointer to the TOF-index indicating the track to be used when evaluating
   *        the beta (default value for TOF_index is 0, corresponding to the TOF stand-alone
   *        track [no TRK information to build the TOF stand-alone track]). The pointer to the
   *        TOF_index for TRK-track as given by TrkPhSinCut can be used.
   *
   * @param resMax See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12])
   * @param qualCut See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12])
   * @param chi2Cut See documentation for ToFLevel2::CalcBeta. Default: 20. (equivalent to beta[12])
   * @param minBeta the minimum beta value (with sign)
   * @param maxBeta the maximum beta value (with sign)
   */
  TofBetaRangeCut(const char *cutName, int *trackTof = NULL, float resMax = 10., float qualCut = 10., float chi2Cut =
      20., float minBeta = -100., float maxBeta = 100.) :
    PamCut(cutName), _trackTof(trackTof), _resMax(resMax), _qualCut(qualCut), _chi2Cut(chi2Cut), _minBeta(minBeta),
        _maxBeta(maxBeta) {
  }
  /*! @brief Destructor. */
  ~TofBetaRangeCut() {
  }

  /*! @brief The TofBetaRange check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if particle beta is inside the specified range (minBeta < beta < maxBeta)
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:

  int *_trackTof;
  float _resMax, _qualCut, _chi2Cut;

  float _minBeta, _maxBeta;

};

#endif /* TOFBETARANGECUT_H_ */
