/*
 * GeoFieldCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file GeoFieldCut.h The GeoFieldCut class definition file */

#ifndef GEOFIELDCUT_H_
#define GEOFIELDCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The geomagnetic field cut. */
class GeoFieldCut: public PamCut {
public:

  /*! @brief Constructor.
   *
   * If the upper value is less than the lower value, it will be ignored.
   *
   * @param cutName The cut's name..
   * @param bAbsMin The lower threshold value of the geomagnetic field, in gauss.
   * @param bAbsMax The upper threshold value of the geomagnetic field, in gauss.
   */
  GeoFieldCut(const char *cutName, Float_t bAbsMin, Float_t bAbsMax = -1.) :
    PamCut(cutName), _bAbsMin(bAbsMin), _bAbsMax(bAbsMax) {
  }

  /*! @brief Destructor. */
  ~GeoFieldCut() {
  }

  /*! @brief Apply the geomagnetic cut.
   *
   * This routine rejects the events with |B| < bAbs.
   * @param event The event to analyze.
   * @return CUTOK if |B| > bAbs, 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:
  float _bAbsMin, _bAbsMax;

};

#endif /* GEOFIELDCUT_H_ */
