/*
 * CaloDedxVsBetaHistoAction.h
 *
 *  Created on: 11/set/2009
 *      Author: Nicola Mori
 */

/*! @file CaloDedxVsBetaHistoAction.h The CaloDedxVsBetaHistoAction class declaration file. */

#ifndef CALODEDXVSBETAHISTOACTION_H_
#define CALODEDXVSBETAHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a Calo dE/dx Vs. Tof Beta histogram. */
class CaloDedxVsBetaHistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param plane The plane from which dE/dx is retrieved (range: [0,21]).
   * @param view The view to use ( 0 = X, 1 = Y).
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  CaloDedxVsBetaHistoAction(const char *actionName, unsigned int plane, unsigned int view, TString outFileBase = "",
      TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "CALO dE/dx vs TOF Beta");

  /*! @brief Destructor */
  ~CaloDedxVsBetaHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

private:

  unsigned int _plane, _view;

};
#endif /* CALODEDXVSBETAHISTOACTION_H_ */
