/*
 * TrkChi2XDeflTimeCut.h
 *
 *  Created on: 6-oct-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkChi2XDeflTimeCut.h The TrkChi2XDeflTimeCut class definition file */

#ifndef TRKCHI2XDEFLTIMECUT_H_
#define TRKCHI2XDEFLTIMECUT_H_

#include "../TrkChi2DeflTimeCut/TrkChi2DeflTimeCut.h"

/*! @brief The tracker chi2 for X view vs deflection cut.
 *
 * Events whose track has been fitted with a chi2 greater than Chi2(eta) are discarded.
 * Chi2(eta) is a function which gives the maximum value of chi2 associated to a certain
 * deflection eta; in current implementation it is parameterized as:
 *
 *   Chi2(eta) = p0 + p1 * eta^2 + p2 * eta ^4
 *
 * where p0, p1 and p2 are parameters. These are read from a file, and are supposed to be
 * computed month by month.
 *
 */

class TrkChi2XDeflTimeCut: public TrkChi2DeflTimeCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param calibFile1 Path for the NX=3 calibration file. See #TrkChi2DeflTimeCut.
   * @param calibFile2 Path for the NX>=4 calibration file. See #TrkChi2DeflTimeCut.
   */
  TrkChi2XDeflTimeCut(const char *cutName, const char *trkAlg, const char *calibFile_nHitX3, const char *calibFile_nHitX4, int nPar=5) :
      TrkChi2DeflTimeCut(cutName, trkAlg, calibFile_nHitX3, calibFile_nHitX4, nPar) {
  }

  /*! @brief Destructor. */
  ~TrkChi2XDeflTimeCut() {
  }

private:
  double _GetChi2(PamLevel2 *event);

};
#endif /* TRKCHI2XDEFLTIMECUT_H_ */
