/*
 * TofBetaRangeCut.h
 *
 *  Created on: 10-apr-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TofBetaRangeCut.h The TofBetaRangeCut class definition file */

#ifndef TOFBETARANGECUT_H_
#define TOFBETARANGECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The TofBetaRange cut.
 * This cut selects a range of beta values. Note that beta can be either positive (downward going particle) or negative (upward going particle).
 */

class TofBetaRangeCut: public PamCut {

public:
  /*! @brief Constructor 
   * @param cutName The cut's name. 
   * @param trkAlg Tracking algorythm to be used ()
   * @param trkId ID of the (physical) track along which beta should be evaluated (default 0, that is the first track)
   * @param resMax See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12])
   * @param qualCut See documentation for ToFLevel2::CalcBeta. Default: 10. (equivalent to beta[12]) 
   * @param chi2Cut See documentation for ToFLevel2::CalcBeta. Default: 20. (equivalent to beta[12])
   * @param minBeta the minimum beta value (with sign)
   * @param maxBeta the maximum beta value (with sign)
   *
   * In order to evaluate the beta of a particle by using the tracker information, the trkAlg should be indicated (e.g."STD"). 
   * For meaningfull analysis, this cut should follow a  TrkPhSinCut (single track), and the indicated trkAlg should be 
   * consistently the same one.
   * If the standalone ToF information is instead required, trkId should be set equal to -1. In this case trkAlg is ignored.
   *
   */


/*   TofBetaRangeCut(const char *cutName, ToFTrkVar *trackTof = NULL, float resMax = 10., float qualCut = 10., float chi2Cut = */
/*       20., float minBeta = -100., float maxBeta = 100.) : */
/*     PamCut(cutName), _trackTof(trackTof), _resMax(resMax), _qualCut(qualCut), _chi2Cut(chi2Cut), _minBeta(minBeta), */
/*         _maxBeta(maxBeta) {       */
/*   } */
    TofBetaRangeCut(const char *cutName, const char *trkAlg, int trkId=0, float resMax = 10., float qualCut = 10., float chi2Cut =
      20., float minBeta = -100., float maxBeta = 100.) :
	PamCut(cutName), _trkAlg(trkAlg), _trkId(trkId), _resMax(resMax), _qualCut(qualCut), _chi2Cut(chi2Cut), _minBeta(minBeta),
        _maxBeta(maxBeta) {      

//	cout << "TofBetaRangeCut("<<cutName<<","<<_trkAlg<<","<<_trkId<<","<<_resMax<<","<<_qualCut<<","<<_chi2Cut<<","<<_minBeta<<","<<_maxBeta<<")"<<endl;
	beta = 0;

  }

  /*! @brief Destructor. */
  ~TofBetaRangeCut() {
  }

  /*! @brief The TofBetaRange check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if particle beta is inside the specified range (minBeta < beta < maxBeta)
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

  float beta;

private:

  const char *_trkAlg;///<Tracking algorythm 
  int _trkId;
  float _resMax, _qualCut, _chi2Cut;

  float _minBeta, _maxBeta;

};

#endif /* TOFBETARANGECUT_H_ */
