/*
 * TrkRigGeoCut.h
 *
 *  Created on: 25-mar-2009
 *      Author: Nicola Mori
 *  Last update: 30-apr-2009
 */

/*! @file TrkRigGeoCut.h The TrkRigGeoCut class definition file */

#ifndef TRKRIGGEOCUT_H_
#define TRKRIGGEOCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The geomagnetic rigidity cut.
 * This cut discards an event whose rigidity modulus is less than a threshold rigidity, given by
 * the geomagnetic cutoff rigidity (the Stoermer cutoff) for that event multiplied by a threshold
 * coefficient.
 *
 * CUT DEPENDENCIES: TrkPhSin (since TrkRigGeoCut assumes the existence of a single physical track)
 */
class TrkRigGeoCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param thresholdCoeff The threshold rigidity coefficient.
   */
    TrkRigGeoCut(const char *cutName, const char *trkAlg, float thresholdCoeff) :
    PamCut(cutName), _trkAlg(trkAlg), _thresholdCoeff(thresholdCoeff) {
  }
  /*! @brief Destructor. */
  ~TrkRigGeoCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the rigidity modulus is greater than the geomagnetic cutoff
   *                rigidity times the threshold coefficient.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

  /*! @brief Returns the threshold coefficient.*/
  float GetThresholdCoeff(){
    return _thresholdCoeff;
  }

private:

  const char *_trkAlg;
  float _thresholdCoeff;

};

#endif /* TRKRIGGEOCUT_H_ */
