/*
 * EffBetaToRigCollection.cpp
 *
 *  Created on: 12/lug/2011
 *      Author: Nicola Mori
 */

/*! @file EffBetaToRigCollection.cpp The EffBetaToRigCollection class implementation file. */

#include "EffBetaToRigCollection.h"

EffBetaToRigCollection::EffBetaToRigCollection(const char *collectionName, TString outFileBase, TString rigBinsFile,
    float mass, float charge, int errMethod, bool owns) :
    BinnedEffCollection(collectionName, outFileBase, rigBinsFile, errMethod, owns), _mass(mass), _charge(charge) {
}
float EffBetaToRigCollection::GetBinValue(PamLevel2 *event) {

  float beta = event->GetToFLevel2()->GetToFTrkVar(0)->beta[12]; // beta standalone
  float gamma = sqrt(1 / (1 - beta * beta));

  return _mass * gamma * beta / _charge;

}
