/*
 * TrkChi2VsDeflHistoAction.h
 *
 *  Created on: 14/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TrkChi2VsDeflHistoAction.h The TrkChi2VsDeflHistoAction class declaration file. */

#ifndef TRKCHI2VSDEFLHISTOACTION_H_
#define TRKCHI2VSDEFLHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>

/*! @brief An action that fills a Trk Chi2 Vs Deflection histogram (for global Chi2, Chi2 X and Chi2 Y). */
class TrkChi2VsDeflHistoAction: public CollectionAction {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param logChi2 If true, log10(chi2) is used for the Y axis (linear scale). Notice that minChi2 and maxChi2
   *                must still be specified using chi2 values and NOT log10(chi2) values.
   * @param minDefl The lower limit for deflection axis (in GV^-1).
   * @param maxDefl The upper limit for deflection axis (in GV^-1).
   * @param nBinsDefl The number of deflection bins.
   * @param minChi2 The lower limit for chi2 axis.
   * @param maxChi2 The upper limit for chi2 axis.
   * @param nBinsChi2 The number of chi2 bins.

   */
  TrkChi2VsDeflHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE", bool logChi2 = false,
      float minDefl = 0.001, float maxDefl = 3.5, unsigned int nBinsDefl = 1000, float minChi2 = 0.01, float maxChi2 =
          1e7, unsigned int nBinsChi2 = 1000);

  /*! @brief Destructor. */
  ~TrkChi2VsDeflHistoAction() {

    if (!_histoX) {
      delete _histoX;
      _histoX = NULL;
    }

    if (!_histoY) {
      delete _histoY;
      _histoY = NULL;
    }
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output ROOT file.*/
  void Finalize();

  /*! @brief  Returns the histogram.
   *
   * @return A pointer to the TH2F chi2 vs deflection histogram.
   */
  TH2F *GetHisto() {
    return &_histo;
  }

private:

  TString _outFileName;
  TH2F _histo;
  TH2F *_histoX, *_histoY;
  TString _mode;
  bool _logChi2;

  streambuf *_cout_sbuf;
  ofstream _fout;
};

#endif /* TRKCHI2VSDEFLHISTOACTION_H_ */
