/*
 * TofBetaVsTrkRigHistoAction.h
 *
 *  Created on: 24/jun/2010
 *      Author: S. Ricciarini
 */

/*! @file TrkDeflVsGPDeflHHistoAction.h The TrkDeflVsGPDeflHHistoAction class declaration file. */

#ifndef TRKDEFLVSGPDEFLHHISTOACTION_H_
#define TRKDEFLVSGPDEFLHHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills the histogram: Trk Deflection (with sign, in GV^-1) vs. GPamela Deflection for H, in (GeV/c)^-1 . */
class TrkDeflVsGPDeflHHistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  TrkDeflVsGPDeflHHistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot =
      true, bool outText = true, TString title = "TRK Defl. (GV)^-1 vs. GP H Defl. (GeV/c)^-1");

  /*! @brief Destructor */
  ~TrkDeflVsGPDeflHHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);


};
#endif /* TRKDEFLVSGPDEFLHHISTOACTION_H_ */
