/*
 * TofDedxVsRigHistoAction.h
 *
 *  Created on: 22-jul-2011
 *      Author: Nicola Mori
 */

/*! @file TofDedxVsRigHistoAction.h The TofDedxVsRigHistoAction class declaration file. */

#ifndef TOFDEDXVSRIGHISTOACTION_H_
#define TOFDEDXVSRIGHISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a TOF dE/dx Vs abs(rigidity) histogram. */
class TofDedxVsRigHistoAction: public Histo2DAction<Int_t> {
public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param layers The layers from which dE/dx is measured. See #TOFLAYERS. If combinations like
   *              S11+S12 are used, the mean dE/dx will be used. dE/dx are computed using track from tracker.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title. If "", the constructor will create a title based on the layers parameter.
   */
  TofDedxVsRigHistoAction(const char *actionName, unsigned int layers, TString outFileBase =
      "", TString mode = "UPDATE", bool outRoot = true, bool outText = true, TString title = "");

  /*! @brief Destructor. */
  ~TofDedxVsRigHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Returns the number of bad events.
   *
   * @return The number of events which were discarded because they contain a bad enrgy measurement
   *         on at least one of the selected layers.
   */
  unsigned int GetNBadEvents() {
    return _badEvents;
  }
private:

  unsigned int _layers;
  unsigned int _nLayers;
  unsigned int _badEvents;

};
#endif /* TOFDEDXVSRIGHISTOACTION_H_ */
