/*
 * EvRateS11VsCutoffHistoAction.h
 *
 *  Created on: 21-mag-2009
 *      Author: Nicola Mori
 */
/*! @file EvRateS11VsCutoffHistoAction.h The EvRateS11VsCutoffHistoAction class declaration file. */

#ifndef EVRATES11VSCUTOFFHISTOACTION_H_
#define EVRATES11VSCUTOFFHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>

/*! @brief An action that fills an event rate on S11 Vs. Stoermer cutoff 2D histogram.
 *
 * The event rate on S11 is the mean of the event rates on each PMT of S11.
 */
class EvRateS11VsCutoffHistoAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param mode The mode of file creation (see documentation of TFile constructor
   *             in ROOT's reference guide)
   */
  EvRateS11VsCutoffHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE");

  /*! @brief Destructor */
  ~EvRateS11VsCutoffHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output file. */
  void Finalize();

private:

  TString _outFileName;
  TH2F _histo;
  TString _mode;

};

#endif /* EVRATES11VSCUTOFFHISTOACTION_H_ */
