/*
 * CaloQtotVsGPP0HistoAction.h
 *
 *  Created on: 01/jun/2010
 *      Author: S. Ricciarini
 */

/*! @file CaloQtotVsGPP0HistoAction.h The CaloQtotVsGPP0HistoAction class declaration file. */

#ifndef CALOQTOTVSGPP0HISTOACTION_H_
#define CALOQTOTVSGPP0HISTOACTION_H_

#include "../Histo2DAction/Histo2DAction.h"

/*! @brief An action that fills a Calo Qtot Vs. GPamela P0 (initial momentum modulus) histogram. */
class CaloQtotVsGPP0HistoAction: public Histo2DAction<Int_t> {

public:

  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileBase The file base name for the ROOT histogram output (".root" will be appended).
   *                    If "", no ROOT output will be produced.
   * @param mode The mode of ROOT file creation (see documentation of TFile constructor
   *             in ROOT's reference guide).
   * @param outRoot If true, an output ROOT file named outFileBase + ".root" will be produced.
   * @param outText If true, an output text file named outFileBase + ".txt" will be produced. It will overwrite an
   *                eventually existing file with the same name.
   * @param title The ROOT histogram title.
   */
  CaloQtotVsGPP0HistoAction(const char *actionName, TString outFileBase = "", TString mode = "UPDATE", bool outRoot =
      true, bool outText = true, TString title = "CAL Qtot Vs. GP Mom");

  /*! @brief Destructor */
  ~CaloQtotVsGPP0HistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);


};
#endif /* CALOQTOTVSGPP0HISTOACTION_H_ */
