/*
 * TrkRigCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkRigCut.h The TrkRigCut class definition file */

#ifndef TRKRIGCUT_H_
#define TRKRIGCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The rigidity cut.
 * This cut discards all the events whose rigidity is above or below a threshold value.
 * Here rigidity is defined as p/Z (GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus:
 * therefore rigidity can be positive or negative.
 *
 */
class TrkRigCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param minRigidity The threshold rigidity p/Z (in GV); can be positive or negative.
   * @param discardBelow If true, events below the threshold rigidity will be discarded;
   *                     otherwise, events above the threshold will be discarded.
   */
  TrkRigCut(const char *cutName, float thrRigidity, bool discardBelow = true ) :
    PamCut(cutName), _thrRigidity(thrRigidity), _discardBelow(discardBelow) {
  }
  /*! @brief Destructor. */
  ~TrkRigCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the rigidity is greater (lower) than the threshold and discardBelow is true (false).
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _thrRigidity;
  bool _discardBelow;

};
#endif /* TRKRIGCUT_H_ */
