/*
 * TofDedxHCut.h
 *
 *  Created on: 5 apr 2011
 *      Author: Nicola Mori
 */

/*! @file TofDedxHCut.h  The TofDedxHCut.h class definition file. */

#ifndef TOFDEDXHCUT_H_
#define TOFDEDXHCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief Cutting a band dE/dx vs. Beta for hydrogen.
 * This cut discards events where TOF dE/dx vs. Beta are outside the hydrogen "corridor". This corridor is currently
 * defined by:
 *
 * dE/dx > _p[0] / (_p[1] * beta + _p[2]) + _p[3] + _p[4] * beta
 * dE/dx < _p[5] / (_p[6] * beta + _p[7]) + _p[8] + _p[9] * beta
 *
 * where p[i] are calibration parameters. Currently, they are available for each single layer; the beta used is the beta[12] corresponding
 * to the TOF standalone track or to the TRK physical track, depending on the value of the standAlone parameter of the constructor. The
 * cut parameters have been obtained using the standalone beta. Currently, no test has been made to see if these parameters are good also
 * for beta from TRK track.
 * If the required combination of planes has no available calibration, the one for S21 will be used. Currently, the 9th reduction uses
 * a dE/dx calibration which allow to use an (almost) unique set of parameters for all layers, but the possibility to define cut parameters
 * for each layer is maintained for possible future refinements.
 * Note that there's no currently available calibration for combinations of layers, so using mean release on many layers could potentially
 * result in an undefined behavior, but given the almost constant cut parameters it should work as expected (however, THIS HAS NOT BEEN TESTED
 * AND IS NOT GUARANTEED).
 */
class TofDedxHCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param layer The layer to use. Select it using values like #S11 (for single layers) or S11+S12 (for the mean of many layers).
   * @param standAlone If true, the cut will use the standalone measure of beta; otherwise it will use the
   *                   physical track.
   * @param strict If true, a more strict cut will be applied (lower efficiency but also lower contamination).
   */
  TofDedxHCut(const char *cutName, unsigned int layer, bool standAlone = true, bool strict = false);
  /*! @brief Destructor. */
  ~TofDedxHCut() {

  }

  /*! @brief The dE/dx vs. beta helium check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if event is inside helium "corridor".
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  unsigned int _layer;
  bool _standAlone;
  const float *_p;
  // Single layers standalone
  static const float _S11_SA_params[10], _S12_SA_params[10], _S21_SA_params[10], _S22_SA_params[10], _S31_SA_params[10],
      _S32_SA_params[10];
  // Single layers standalone, strict selection
  static const float _S11_SA_params_strict[10], _S12_SA_params_strict[10], _S21_SA_params_strict[10],
      _S22_SA_params_strict[10], _S31_SA_params_strict[10], _S32_SA_params_strict[10];
};

#endif /* TOFDEDXHCUT_H_ */
