/*
 * CoordHistoAction.h
 *
 *  Created on: 11-giu-2009
 *      Author: mori
 */

/*! @file CoordHistoAction.h The CoordHistoAction class declaration file. */

#ifndef COORDHISTOACTION_H_
#define COORDHISTOACTION_H_

#include "../CollectionAction/CollectionAction.h"
#include <TH2F.h>
#include <TH1F.h>

/*! @brief An action that fills a latitude Vs longitude 2D histogram and an altitude 1D histogram. */
class CoordHistoAction: public CollectionAction {

public:
  /*! @brief Constructor.
   *
   * @param actionName The action's name.
   * @param outFileName The output file name.
   * @param mode The mode of file creation (see documentation of TFile constructor
   *             in ROOT's reference guide)
   */
  CoordHistoAction(const char *actionName, TString outFileName, TString mode = "UPDATE");

  /*! @brief Destructor */
  ~CoordHistoAction() {
  }

  /*! @brief Fills histogram with the selected event.
   *
   * @param event The selected event.
   */
  void OnGood(PamLevel2 *event);

  /*! @brief Writes the histogram to the output file. */
  void Finalize();

private:

  TString _outFileName;
  TH2F _histoLatLong;
  TH2F _histoRateS11;
  TH2F _histoRateS12;
  TH1F _histoAlt;
  TH1F _histoEta;
  TH1F _histoTheta;
  TH1F _histoPhi;
  TH1F _histoPitch;
  TString _mode;

  TH1F _rateRate;

};
#endif /* COORDHISTOACTION_H_ */
