/*
 * PamCutEnv.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */
/*! @brief Top level header for PamCut framework, including all sub-headers.
 *
 * To use the PamCut framework it is sufficient to include this header file.
 */
#ifndef PAMCUTENV_H_
#define PAMCUTENV_H_

/* The base class definitions (PamCut and PamCutCollection) */
#include "PamCutBase/PamCutBase.h"

/* Collections */
#include "Collections/Collections.h"

/* Cuts */
#include "ACCuts/ACCuts.h"
#include "CaloCuts/CaloCuts.h"
#include "TofCuts/TofCuts.h"
#include "TrkCuts/TrkCuts.h"
#include "MiscCuts/MiscCuts.h"


#endif /* PAMCUTENV_H_ */
