/*
 * TofBetaRangeCut.cpp
 *
 *  Created on: 10-apr-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaRangeCut.cpp The TofBetaRangeCut class implementation file */

#include "TofBetaRangeCut.h"

int TofBetaRangeCut::Check(PamLevel2 *event) {

  int iTrackTof=0; // index initialized (default) to 0 (TOF stand-alone track)
  
  if (! (_trackTof==0) ) {
    iTrackTof=*_trackTof;
  }

  float _beta = event->GetToFLevel2()->CalcBeta(iTrackTof,_resMax,_qualCut,_chi2Cut);

  if( ! (_minBeta < _beta && _beta < _maxBeta) ) {
    return 0;
  }

  return CUTOK;
  
}
