// $Id: PamVMCPrimaryGenerator.h,v 1.0 2007/06/03 


#ifndef PAMVMC_PRIMARY_GENERATOR_H
#define PAMVMC_PRIMARY_GENERATOR_H

#include <TVirtualMCApplication.h>

class TVirtualMCStack;
class TVector3;

class PamVMCPrimaryGenerator : public TObject
{
  public:
    PamVMCPrimaryGenerator(TVirtualMCStack* stack); 
    PamVMCPrimaryGenerator();
    virtual ~PamVMCPrimaryGenerator();

    // methods
    void GeneratePrimaries();

    // set methods
    void SetParticle(Int_t pdg);
    void SetKinEnergy(Double_t kinEnergy);
    void SetDirection(Double_t dirX, Double_t dirY, Double_t dirZ);
    void SetOptPhotonPolar(Double_t angle);
    void SetNofPrimaries(Int_t nofPrimaries);
 
  private:
    // methods
    void GeneratePrimary();

    // data members
    TVirtualMCStack*  fStack; 
    Int_t             fPdg;
    Double_t          fKinEnergy;
    Double_t          fDirX;
    Double_t          fDirY;
    Double_t          fDirZ;
    Double_t          fPolAngle;   
    Int_t             fNofPrimaries;

  ClassDef(PamVMCPrimaryGenerator,1)  //PamVMCPrimaryGenerator
};

// inline functions

inline void PamVMCPrimaryGenerator::SetParticle(Int_t pdg)
{ fPdg = pdg; }

inline void PamVMCPrimaryGenerator::SetKinEnergy(Double_t kinEnergy)
{ fKinEnergy = kinEnergy; }

inline void PamVMCPrimaryGenerator::SetNofPrimaries(Int_t nofPrimaries)
{ fNofPrimaries = nofPrimaries; }

#endif //PAMVMC_PRIMARY_GENERATOR_H

