// $Id: PamVMCApplication.h,v 1.0 2007/06/01
// 
// Class PamVMCApplication
// ----------------------- 
// Implementation of the TVirtualMCApplication

#ifndef PAMVMC_APPLICATION_H
#define PAMVMC_APPLICATION_H

#include <TVirtualMCApplication.h>
#include "TMCVerbose.h"

#ifdef PAMFIELD
#include "TrkLevel2.h"
#endif

class PamVMCStack;
class PamVMCDetectorConstruction;
class PamVMCPrimaryGenerator;

class PamVMCApplication : public TVirtualMCApplication
{
  public:
    PamVMCApplication(const char* name,  const char *title);
    PamVMCApplication();
    virtual ~PamVMCApplication();
  
    // static access method
    static PamVMCApplication* Instance(); 

    // methods
    void InitMC(const char *setup);
    void RunMC(Int_t nofEvents);
 
    virtual void ConstructGeometry();
    virtual void InitGeometry();
    virtual void GeneratePrimaries();
    virtual void BeginEvent();
    virtual void BeginPrimary();
    virtual void PreTrack();
    virtual void Stepping();
    virtual void PostTrack();
    virtual void FinishPrimary();
    virtual void FinishEvent();
    virtual void Field(const Double_t* x, Double_t* b) const;
    
    // set methods
    void  SetVerboseLevel(Int_t verboseLevel);
 
    // get methods
    PamVMCPrimaryGenerator*  GetPrimaryGenerator() const;
 
 
  private:
    // methods
    void RegisterStack();
  
    // data members
    Int_t                     fEventNo;

    TMCVerbose                fVerbose;
    PamVMCStack*              fStack;
    PamVMCDetectorConstruction* fDetConstruction;
    PamVMCPrimaryGenerator*     fPrimaryGenerator;
#ifdef PAMFIELD
    TrkLevel2 pamfield;
#endif
  ClassDef(PamVMCApplication,1)  //Interface to MonteCarlo application
};

// inline functions

inline PamVMCApplication* PamVMCApplication::Instance()
{ return (PamVMCApplication*)(TVirtualMCApplication::Instance()); }

inline void  PamVMCApplication::SetVerboseLevel(Int_t verboseLevel)
{ fVerbose.SetLevel(verboseLevel); }

inline PamVMCPrimaryGenerator*  PamVMCApplication::GetPrimaryGenerator() const
{ return fPrimaryGenerator; }


#endif //PAMVMC_APPLICATION_H

