// $Id: PamVMCApplication.h,v 1.0 2007/06/01
// 
// Class PamVMCApplication
// ----------------------- 
// Implementation of the TVirtualMCApplication

//#define PAMFIELD 1

#ifndef PAMVMC_APPLICATION_H
#define PAMVMC_APPLICATION_H

#include <TVirtualMCApplication.h>
#include "TMCVerbose.h"

#include "PamVMCCaloSD.h"
#include "PamVMCTrkSD.h"
#include "PamVMCTofSD.h"
#include "PamVMCCardSD.h"
#include "PamVMCCasSD.h"
#include "PamVMCCatSD.h"
#include "PamVMCS4SD.h"
#include "PamVMCNDSD.h"
#include "PamVMCDetectorSD.h"
#include "PamRootManager.h"
#include "PamVMCDetectorHit.h"
#include <TMap.h>
//#include <TLorentzVector.h>

#ifdef PAMFIELD
#include "TrkLevel2.h"
#endif

class PamVMCStack;
class PamVMCDetectorConstruction;
class PamVMCPrimaryGenerator;
class PamVMCCaloSD;
class PamVMCTrkSD;
class PamVMCTofSD;
class PamVMCCardSD;
class PamVMCCasSD;
class PamVMCCatSD;
class PamVMCS4SD;
class PamVMCNDSD;

class PamVMCApplication : public TVirtualMCApplication
{
  public:
    PamVMCApplication(const char* name,  const char *title);
    PamVMCApplication();
    virtual ~PamVMCApplication();
  
    // static access method
    static PamVMCApplication* Instance(); 

    // methods
    void InitMC(const char *setup);
    void RunMC(Int_t nofEvents);
 
    virtual void ConstructGeometry();
    virtual void InitGeometry();
    virtual void GeneratePrimaries();
    virtual void BeginEvent();
    virtual void BeginPrimary();
    virtual void PreTrack();
    virtual void Stepping();
    virtual void PostTrack();
    virtual void FinishPrimary();
    virtual void FinishEvent();
    virtual void FinishRun();
    virtual void Field(const Double_t* x, Double_t* b) const;
    
    // set methods
    void  SetVerboseLevel(Int_t verboseLevel);
 
    // get methods
    PamVMCPrimaryGenerator*  GetPrimaryGenerator() const;

 
 
  private:


    // data members
    Int_t                     fEventNo;
    TMCVerbose                fVerbose;
    PamVMCStack*              fStack;
    PamVMCDetectorConstruction* fDetConstruction;
    PamVMCPrimaryGenerator*     fPrimaryGenerator;
    PamRootManager             fRootManager;
    pHitData            ftemphit;  
    TMap                fdetmap;
    fin fdstatus;


    // methods
    void RegisterStack();
  
  //    void CleanTempHit(){ ftemphit.Clean();}
    void FillTempHit();
    void Register() {
   
      std::cout <<" Into Register() " << std::endl;
      //  fdetmap.Print();
      TMapIter *n= (TMapIter *)fdetmap.MakeIterator(); 
      TObject *o; while( o=(TObject *) n->Next()) { 

        cout<<"!!KEY=<<"<< endl;
	((PamVMCDetectorSD *)fdetmap.GetValue(o))->Register();
      }
    };



#ifdef PAMFIELD
    TrkLevel2 pamfield;
#endif
  ClassDef(PamVMCApplication,1)  //Interface to MonteCarlo application
};

// inline functions

inline PamVMCApplication* PamVMCApplication::Instance()
{ return (PamVMCApplication*)(TVirtualMCApplication::Instance()); }

inline void  PamVMCApplication::SetVerboseLevel(Int_t verboseLevel)
{ fVerbose.SetLevel(verboseLevel); }

inline PamVMCPrimaryGenerator*  PamVMCApplication::GetPrimaryGenerator() const
{ return fPrimaryGenerator; }



#endif //PAMVMC_APPLICATION_H

