#include "TROOT.h"
#include "TVirtualMC.h"
#include "TGeant4.h"
#include "TString.h"
#include "PamVMCApplication.h"

#include <iostream>
// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with Geant4. 

using std::cout;
using std::endl;

//void run_g4(const TString& configMacro = "g4Config.C") 
  int main(){
    TROOT nik("Nikolay","Nikonov"); 

    TString configMacro = "g4Config.C"; 
    // Load basic libraries
    gROOT->LoadMacro("./macro/basiclibs.C");
    basiclibs();
    
    // Load PAMELA libs
    TString PAMLIB=gSystem->Getenv("PAM_LIB");
    gSystem->Load(PAMLIB+"/libyoda.so");
    gSystem->Load(PAMLIB+"/libDarthVader.so");
    gSystem->Load(PAMLIB+"/libPamLevel2.so");
    
    // Load Geant4 libraries
    
    gROOT->LoadMacro("./macro/PamG4Libs.C");
    PamG4Libs();
    
    // Load this example libraries
    TString G4WD=gSystem->Getenv("G4WORKDIR");
    TString PLAT=gSystem->Getenv("PLATFORM");
    gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC");
    
    // MC application
    PamVMCApplication* appl 
      = new PamVMCApplication("PAMG4_VMC", "PAMELA GEANT4 VMC application");
    
    appl->GetPrimaryGenerator()->SetNofPrimaries(1);  
    appl->SetVerboseLevel(1);  
    
    // Macro to run with primary = polarized optical photon
    //gROOT->LoadMacro("optPhoton.C");
    //optPhoton();  
    
    // Initialize MC
    appl->InitMC(configMacro);
    
    // Customise Geant4 setting after initialization:
    // Physics list
    ((TGeant4*)gMC)->ProcessGeantMacro("g4config2.in");
    // Visualization settings
    //   ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");
    
    // Run MC
    appl->RunMC(5000);
    appl->FinishRun();
    delete appl;
    return 0;
  }  
