// $Id: run_g4.C,v 1.0 2007/06/01 
//
// Macro for running G4PAM_VMC with 
class TFluka; 

void run_fluka(const TString& configMacro = "flukaConfig.C") 
{
  // Load basic libraries
  gROOT->LoadMacro("./macro/basiclibs.C");
  basiclibs();

  // Load PAMELA libs
  TString PAMLIB=gSystem->Getenv("PAM_LIB");
  gSystem->Load(PAMLIB+"/libyoda.so");
  gSystem->Load(PAMLIB+"/libDarthVader.so");
  gSystem->Load(PAMLIB+"/libPamLevel2.so");


  // Load Geant4 libraries
  
  //  gROOT->LoadMacro("./macro/PamG4Libs.C");
  //PamG4Libs();

  // Load this example libraries
  TString G4WD=gSystem->Getenv("G4WORKDIR");
  TString PLAT=gSystem->Getenv("PLATFORM");
   gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamVMC");

  // MC application
  PamVMCApplication* appl 
    = new PamVMCApplication("PAMFLUKA_VMC", "PAMELA GEANT4 VMC application");
    
   gSystem->Load("/home/nikolas/aliroot/v4-05-10/lib/tgt_linux/libTFluka");
   new TFluka("pamfluka",4,1);
   //   gMC->Init();
//    appl->GetPrimaryGenerator()->SetNofPrimaries(1);  
   appl->SetVerboseLevel(1);  
//    appl->ConstructGeometry();
  // Macro to run with primary = polarized optical photon
  //gROOT->LoadMacro("optPhoton.C");
  //optPhoton();  

  // Initialize MC
   appl->InitMC(configMacro);
  
  // Customise Geant4 setting after initialization:
  // Physics list
      //  ((TGeant4*)gMC)->ProcessGeantMacro("g4config2.in");
  // Visualization settings
  // ((TGeant4*)gMC)->ProcessGeantMacro("g4vis.in");

  // Run MC
   appl->RunMC(1);

      //  delete appl;

   // return 

}  
