// $Id: g4Config.C,v 1.0 2007/06/01  Exp $
//
// Configuration macro for Geant4 VirtualMC for PamG4VMC
// for geometry defined with Root and selected Geant4 native navigation

void Config()
{
  
  gSystem->Load("libG4phys_builders");
  gSystem->Load("libG4phys_lists");
  TString G4WD=gSystem->Getenv("G4WORKDIR");
  TString PLAT=gSystem->Getenv("PLATFORM");
  gSystem->Load(G4WD+"/lib/tgt_"+PLAT+"/libPamG4RunConfiguration");
  cout<<G4WD+"/lib/tgt_"+PLAT+"/libPamG4RunConfiguration";
  PamG4RunConfiguration* runConfiguration 
    = new PamG4RunConfiguration("geomRootToGeant4");
  
  // Switch on optical physics (not activated by default)
  /// TG4PhysicsListOptions options;
  ////runConfiguration->SetPhysicsListOptions(options);
  // TGeant4
  TGeant4* geant4
    = new TGeant4("TGeant4_PAMELA", "The Geant4 PAMELA Monte Carlo", runConfiguration);

  // Customise Geant4 setting
  // (verbose level, global range cut, ..)
  geant4->ProcessGeantMacro("g4config.in");
}
