#ifndef PAMVMCCALOID_H
#define PAMVMCCALOID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define CALSD "CAST"
#define CALOF 3

using std::cout;
using std::endl;

struct pCalID: public pGeoID {
  Int_t casiNo;
  Int_t caplNo;
  Int_t castNo;

  pCalID(): casiNo(-1), caplNo(-1), castNo(-1) {};
  pCalID(Int_t offset): pGeoID(offset), casiNo(-1), caplNo(-1), castNo(-1) {};
  pCalID & operator = (const pCalID &pid) {
    casiNo=pid.casiNo;
    caplNo=pid.caplNo;
    castNo=pid.castNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      //      if(gMC->CurrentEvent()){
      	gMC->CurrentVolID(castNo);
      	gMC->CurrentVolOffID(1,casiNo);
      	gMC->CurrentVolOffID(2,caplNo);
      	t= kTRUE;
	//Print();
	//}
    }
    return t;
  }

  Int_t GetID() const {
    Int_t fact;
    switch(casiNo){
    case 1:
    case 4:
    case 7: 
      fact=0;
      break;
    case 2:
    case 5:
    case 8:
      fact=32;
      break;
    case 3: 
    case 6: 
    case 9:
      fact=64;
      break;
    default:
      fact=0;
      break;
    }
    return (caplNo-1)*96+fact+castNo; 
  }

  void Print(const Option_t* ="") const { 
    cout << " pCalID : castNo " << castNo 
	 << ", casiNo " << casiNo << ", caplNo " << caplNo 
	 << ", actual POS " << GetID() << endl;
  }

};

// class PamVMCCaloID: public PamVMCGeoID {

//  private: 

//   pCalID fcalid;

//  public:
//   PamVMCCaloID() : PamVMCGeoID(CALSD ,CALOF) {};
//   void FillVolID(pGeoID *gid){ fcalid = *(pCalID *)gid; };

//   //ClassDef(PamVMCCaloID,1)

// };


#endif // PAMVMCCALOID_H
