// $Id: PamG4VMCDetectorConstruction.cxx,v 1.0 2007/06/01 
//
// PAMELA ROOT TGeo geometry
//
 
#include <Riostream.h>
#include <TVirtualMC.h>
#include <TGeoManager.h>

#include "PamVMCDetectorConstruction.h"

ClassImp(PamVMCDetectorConstruction)

PamVMCDetectorConstruction::PamVMCDetectorConstruction()
  : TObject()
{


}


PamVMCDetectorConstruction::~PamVMCDetectorConstruction()
{
// Destructor
}


//Public methods

void PamVMCDetectorConstruction::ConstructGeometry()
{
     new TGeoManager("PAM_GEOM","PamVMCDetectorConstruction.cxx");


//-----------List of Materials and Mixtures--------------

TGeoMaterial *mat1 = new TGeoMaterial("HYDROGEN",1.01,1,0.7080000E-01);
    mat1->SetUniqueID(   1);
TGeoMaterial *mat2 = new TGeoMaterial("DEUTERIUM",2.01,1,0.162);
    mat2->SetUniqueID(   2);
TGeoMaterial *mat3 = new TGeoMaterial("HELIUM",4,2,0.125);
    mat3->SetUniqueID(   3);
TGeoMaterial *mat4 = new TGeoMaterial("LITHIUM",6.94,3,0.534);
    mat4->SetUniqueID(   4);
TGeoMaterial *mat5 = new TGeoMaterial("BERILLIUM",9.01,4,1.848);
    mat5->SetUniqueID(   5);
TGeoMaterial *mat6 = new TGeoMaterial("CARBON",12.01,6,2.265);
    mat6->SetUniqueID(   6);
TGeoMaterial *mat7 = new TGeoMaterial("NITROGEN",14.01,7,0.808);
    mat7->SetUniqueID(   7);
TGeoMaterial *mat8 = new TGeoMaterial("NEON",20.18,10,1.207);
    mat8->SetUniqueID(   8);
TGeoMaterial *mat9 = new TGeoMaterial("ALUMINIUM",26.98,13,2.7);
    mat9->SetUniqueID(   9);
TGeoMaterial *mat10 = new TGeoMaterial("IRON",55.85,26,7.87);
    mat10->SetUniqueID(  10);
TGeoMaterial *mat11 = new TGeoMaterial("COPPER",63.54,29,8.96);
    mat11->SetUniqueID(  11);
TGeoMaterial *mat12 = new TGeoMaterial("TUNGSTEN",183.85,74,19.3);
    mat12->SetUniqueID(  12);
TGeoMaterial *mat13 = new TGeoMaterial("LEAD",207.19,82,11.35);
    mat13->SetUniqueID(  13);
TGeoMaterial *mat14 = new TGeoMaterial("URANIUM",238.03,92,18.95);
    mat14->SetUniqueID(  14);
TGeoMaterial *mat15 = new TGeoMaterial("AIR",14.61,7.3,0.1205000E-02);
    mat15->SetUniqueID(  15);
TGeoMaterial *mat16 = new TGeoMaterial("VACUUM",0,0,0);
    mat16->SetUniqueID(  16);
TGeoMixture *mat17 = new TGeoMixture("SCINT",2,   1.03200    );
    mat17->SetUniqueID(  17);
    mat17->DefineElement(0,12.01,6,0.922427);
    mat17->DefineElement(1,1.01,1,0.7757296E-01);
TGeoMixture *mat18 = new TGeoMixture("G10",2,   1.70000    );
    mat18->SetUniqueID(  18);
    mat18->DefineElement(0,60.06,30,0.4686818);
    mat18->DefineElement(1,102.13,48,0.5313182);
TGeoMaterial *mat19 = new TGeoMaterial("N2GAS",14.01,7,0.1250000E-02);
    mat19->SetUniqueID(  19);
TGeoMaterial *mat20 = new TGeoMaterial("SILICON TR",28.09,14,2.33);
    mat20->SetUniqueID(  20);
TGeoMaterial *mat21 = new TGeoMaterial("SILICON CA",28.09,14,2.33);
    mat21->SetUniqueID(  21);
TGeoMaterial *mat22 = new TGeoMaterial("XENON",131.29,54,0.5858000E-02);
    mat22->SetUniqueID(  22);
TGeoMaterial *mat23 = new TGeoMaterial("TRDRAD",12.01,6,0.6000000E-02);
    mat23->SetUniqueID(  23);
TGeoMaterial *mat24 = new TGeoMaterial("AEROGEL",96.11,54,0.2);
    mat24->SetUniqueID(  24);
TGeoMixture *mat25 = new TGeoMixture("TUNGA",3,   18.1000    );
    mat25->SetUniqueID(  25);
    mat25->DefineElement(0,183.5,74,0.9827841);
    mat25->DefineElement(1,58.6934,28,0.8272327E-02);
    mat25->DefineElement(2,63.456,29,0.8943575E-02);
TGeoMixture *mat26 = new TGeoMixture("CERAMIC",4,   2.59400    );
    mat26->SetUniqueID(  26);
    mat26->DefineElement(0,26.98,13,0.21);
    mat26->DefineElement(1,28.09,14,0.217);
    mat26->DefineElement(2,16,8,0.558);
    mat26->DefineElement(3,1.01,1,0.1500000E-01);
TGeoMixture *mat27 = new TGeoMixture("G10C",4,   1.70000    );
    mat27->SetUniqueID(  27);
    mat27->DefineElement(0,28.09,14,0.53);
    mat27->DefineElement(1,16,8,0.3);
    mat27->DefineElement(2,12.01,6,0.15);
    mat27->DefineElement(3,1.01,1,0.2000000E-01);
TGeoMixture *mat28 = new TGeoMixture("PLAST",2,   1.03200    );
    mat28->SetUniqueID(  28);
    mat28->DefineElement(0,12.01,6,0.9929774);
    mat28->DefineElement(1,1.01,1,0.7022570E-02);
TGeoMixture *mat29 = new TGeoMixture("MYLAR",3,   1.39000    );
    mat29->SetUniqueID(  29);
    mat29->DefineElement(0,12.011,6,0.6250159);
    mat29->DefineElement(1,1.00794,1,0.4196011E-01);
    mat29->DefineElement(2,15.9994,8,0.3330241);
TGeoMixture *mat30 = new TGeoMixture("POLYSTYRENE",2,  0.350000E-01);
    mat30->SetUniqueID(  30);
    mat30->DefineElement(0,12.011,6,0.9225789);
    mat30->DefineElement(1,1.00794,1,0.7742105E-01);
TGeoMaterial *mat31 = new TGeoMaterial("CADMIUM",112.411,48,8.65);
    mat31->SetUniqueID(  31);
TGeoMixture *mat32 = new TGeoMixture("TIALVA",3,   4.49234    );
    mat32->SetUniqueID(  32);
    mat32->DefineElement(0,47.867,22,0.9);
    mat32->DefineElement(1,26.9815,13,0.6000000E-01);
    mat32->DefineElement(2,50.9415,23,0.4000000E-01);
TGeoMaterial *mat33 = new TGeoMaterial("He3",3,2,0.1246000E-02);
    mat33->SetUniqueID(  33);
TGeoMixture *mat34 = new TGeoMixture("POLYETHYLENE",2,  0.930000    );
    mat34->SetUniqueID(  34);
    mat34->DefineElement(0,12.011,6,0.8562844);
    mat34->DefineElement(1,1.00794,1,0.1437155);

//-----------List of Tracking Media--------------

TGeoMedium *med1 = new TGeoMedium("ALUMINIUM",1,9,-1,1,40,1,100,0.5000000E-01,0.1425,0.5000000E-03);
////TGeoMedium *med2 = new TGeoMedium("G10",2,18,-1,1,40,1,0.15,0.5000000E-01,0.1750000E-02,0.5000000E-03);//////NOT USING BELOW/////
TGeoMedium *med3 = new TGeoMedium("N2 GAS",3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);
////TGeoMedium *med4 = new TGeoMedium("TUNGSTEN",4,12,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.2630000E-02,0.5000000E-03);/////NOT USING BELOW/////
TGeoMedium *med5 = new TGeoMedium("IRON",5,10,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.8000000E-01,0.5000000E-03);
TGeoMedium *med6 = new TGeoMedium("KAPTON",6,17,1,1,40,1,100,0.5000000E-01,0.6000012E-04,0.5000000E-03);
////TGeoMedium *med7 = new TGeoMedium("TRD RADIATOR",7,23,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1520000E-01,0.5000000E-03);/////NOT USING BELOW/////
////TGeoMedium *med8 = new TGeoMedium("ROACELL",8,17,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.2000000E-01,0.5000000E-03);/////NOT USING BELOW/////
TGeoMedium *med9 = new TGeoMedium("CARBON FIBER",9,17,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.5000000E-02,0.5000000E-03);
TGeoMedium *med10 = new TGeoMedium("SCINTILLATOR",10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);
TGeoMedium *med11 = new TGeoMedium("SICALO",11,21,1,1,40,1,100,0.5000000E-01,0.3800000E-03,0.5000000E-03);
TGeoMedium *med12 = new TGeoMedium("SITRACKER",12,20,1,1,40,1,0.1000000E-02,0.5000000E-01,0.5000000E-04,0.1569056E-01);
/////TGeoMedium *med13 = new TGeoMedium("XENON",13,22,1,1,40,1,0.5000000E-01,0.5000000E-01,0.2000000E-02,0.5000000E-03);/////NOT USING BELOW/////
////TGeoMedium *med14 = new TGeoMedium("AEROGEL",14,24,1,1,40,1,0.5000000E-01,0.5000000E-01,0.2000000E-01,0.5000000E-03);/////NOT USING BELOW/////
TGeoMedium *med15 = new TGeoMedium("TUNGA",15,25,-1,1,40,1,100,0.5000000E-01,0.2630000E-02,0.5000000E-03);
TGeoMedium *med16 = new TGeoMedium("KAOLINITE",16,26,-1,1,40,1,100,0.5000000E-01,0.5000000E-04,0.5000000E-03);
TGeoMedium *med17 = new TGeoMedium("G10C",17,27,-1,1,40,1,100,0.5000000E-01,0.1200000E-02,0.5000000E-03);
TGeoMedium *med18 = new TGeoMedium("PLASTIC",18,28,-1,1,40,1,100,0.5000000E-01,0.1000000E-01,0.5000000E-03);
TGeoMedium *med19 = new TGeoMedium("MYLAR",19,29,-1,1,40,1,100,0.5000000E-01,0.2300000E-04,0.5000000E-03);
TGeoMedium *med20 = new TGeoMedium("POLYSTYRENE",20,30,-1,1,40,1,100,0.5000000E-01,0.4000000E-02,0.5000000E-03);
TGeoMedium *med21 = new TGeoMedium("CADMIUM",21,31,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.5000000E-03,0.5000000E-03);
TGeoMedium *med22 = new TGeoMedium("He3",22,33,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1840000E-01,0.5000000E-03);
TGeoMedium *med23 = new TGeoMedium("POLYETHYLENE",23,34,-1,1,40,1,100,0.5000000E-01,0.2000000E-01,0.5000000E-03);
TGeoMedium *med24 = new TGeoMedium("TITANIUM Mixture",24,32,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.3200000E-01,0.5000000E-03);

//-----------List of Rotation matrices--------------

TGeoRotation *rot1 = new TGeoRotation("rot1",90,90,90,180,0,0);
TGeoRotation *rot2 = new TGeoRotation("rot2",90,0,180,90,90,90);
TGeoRotation *rot3 = new TGeoRotation("rot3",90,90,90,360,180,0);
TGeoRotation *rot4 = new TGeoRotation("rot4",90,180,90,270,0,0);
TGeoRotation *rot5 = new TGeoRotation("rot5",90,180,90,90,180,0);
TGeoRotation *rot6 = new TGeoRotation("rot6",90,270,90,360,0,0);
TGeoRotation *rot7 = new TGeoRotation("rot7",0,0,90,90,90,180);
TGeoRotation *rot8 = new TGeoRotation("rot8",180,0,90,90,90,0);
TGeoRotation *rot9 = new TGeoRotation("rot9",90,180,90,90,180,0);
TGeoRotation *rot10 = new TGeoRotation("rot10",90,0,90,270,180,0);
TGeoRotation *rot11 = new TGeoRotation("rot11",90,0,73,90,163,90);
TGeoRotation *rot12 = new TGeoRotation("rot12",90,180,253,270,163,270);
TGeoRotation *rot13 = new TGeoRotation("rot13",90,270,70,0,160,0);
TGeoRotation *rot14 = new TGeoRotation("rot14",90,90,70,180,160,180);

//-----------List of Volumes--------------

TGeoVolume *PAME = gGeoManager->MakeTube("PAME",med3,0,53,130);
TGeoVolume *SHEL = gGeoManager->MakeCone("SHEL",med1,38.25,52.5,52.65,43.77,43.92);
TGeoVolume *TSPH = gGeoManager->MakeSphere("TSPH",med1,239.83,240,0,10.54455,0,360);
TGeoVolume *MSHE = gGeoManager->MakeTube("MSHE",med1,52.5,52.75,20);
TGeoVolume *BSPH = gGeoManager->MakeSphere("BSPH",med1,52.5,52.75,90,180,0,360);
TGeoVolume *TPLA = gGeoManager->MakeBox("TPLA",med3,28,27.165,1.6);
TGeoVolume *TPTU = gGeoManager->MakeBox("TPTU",med24,2.55,1.95,0.6);
TGeoVolume *TPTM = gGeoManager->MakeBox("TPTM",med24,3.45,3.3,0.75);
TGeoVolume *TPTL = gGeoManager->MakeBox("TPTL",med24,21.9,21.1,0.25);
TGeoVolume *TPCV = gGeoManager->MakeBox("TPCV",med3,8.5,7,0.25);
TGeoVolume *S1__ = gGeoManager->MakeBox("S1",med1,20.4184,16.5138,1.3976);
TGeoVolume *S2__ = gGeoManager->MakeBox("S2",med1,9.0046,7.5046,0.7476);
TGeoVolume *S1A_ = gGeoManager->MakeBox("S1A",med3,20.4184,16.5138,1.3646);
TGeoVolume *S2A_ = gGeoManager->MakeBox("S2A",med3,9.0046,7.5046,0.7146);
TGeoVolume *S3__ = gGeoManager->MakeBox("S3",med3,9.010349,7.51035,0.7819);
TGeoVolume *S11M = gGeoManager->MakeBox("S11M",med19,2.5523,16.5,0.3523);
TGeoVolume *S12M = gGeoManager->MakeBox("S12M",med19,20.4,2.7523,0.3523);
TGeoVolume *S21M = gGeoManager->MakeBox("S21M",med19,9,3.7523,0.2523);
TGeoVolume *S22M = gGeoManager->MakeBox("S22M",med19,4.5023,7.5,0.2523);
TGeoVolume *S31M = gGeoManager->MakeBox("S31M",med19,3.00345,7.5,0.35345);
TGeoVolume *S32M = gGeoManager->MakeBox("S32M",med19,9,2.50345,0.35345);
TGeoVolume *POL1 = gGeoManager->MakeBox("POL1",med20,20.4184,16.5138,0.45);
TGeoVolume *POL2 = gGeoManager->MakeBox("POL2",med20,20.4184,16.5138,0.2);
TGeoVolume *POLY = gGeoManager->MakeBox("POLY",med20,9.0046,7.5046,0.2);
TGeoVolume *S4AL = gGeoManager->MakeBox("S4AL",med1,24.2,24.2,0.6);
TGeoVolume *S4__ = gGeoManager->MakeBox("S4",med10,24.1,24.1,0.5);
TGeoVolume *S11Y = gGeoManager->MakeBox("S11Y",med10,2.55,16.5,0.35);
TGeoVolume *S12X = gGeoManager->MakeBox("S12X",med10,20.4,2.75,0.35);
TGeoVolume *S21X = gGeoManager->MakeBox("S21X",med10,9,3.75,0.25);
TGeoVolume *S22Y = gGeoManager->MakeBox("S22Y",med10,4.5,7.5,0.25);
TGeoVolume *S31Y = gGeoManager->MakeBox("S31Y",med10,3,7.5,0.35);
TGeoVolume *S32X = gGeoManager->MakeBox("S32X",med10,9,2.5,0.35);
TGeoVolume *CATA = gGeoManager->MakeBox("CATA",med3,28,0.6,27.165);
TGeoVolume *ATBB = gGeoManager->MakeBox("ATBB",med1,28,0.6,27.165);
TGeoVolume *PLA2 = gGeoManager->MakeBox("PLA2",med18,27.65,0.4,26.815);
TGeoVolume *TOP1 = gGeoManager->MakeBox("TOP1",med10,26.85,0.4,26.015);
TGeoVolume *PTBM = gGeoManager->MakeBox("PTBM",med18,10.11,0.4,8.44);
TGeoVolume *ATBM = gGeoManager->MakeBox("ATBM",med1,9.41,0.4,7.74);
TGeoVolume *LTBM = gGeoManager->MakeBox("LTBM",med3,9.11,0.6,7.44);
TGeoVolume *PTBC = gGeoManager->MakeBox("PTBC",med18,4.975,0.4,5.5575);
TGeoVolume *ATBC = gGeoManager->MakeBox("ATBC",med1,4.975,0.4,5.5575);
TGeoVolume *LTBC = gGeoManager->MakeBox("LTBC",med3,4.975,0.6,5.5575);
TGeoVolume *PTRT = gGeoManager->MakeTrd1("PTRT",med18,0,16.9,0.4,2.405);
TGeoVolume *ATRT = gGeoManager->MakeTrd1("ATRT",med1,0,17.7,0.4,2.405);
TGeoVolume *LTRT = gGeoManager->MakeTrd1("LTRT",med3,0,18.05,0.6,2.405);
TGeoVolume *PTRB = gGeoManager->MakeTrd1("PTRB",med18,16.9,0,0.4,2.405);
TGeoVolume *ATRB = gGeoManager->MakeTrd1("ATRB",med1,17.7,0,0.4,2.405);
TGeoVolume *LTRB = gGeoManager->MakeTrd1("LTRB",med3,18.05,0,0.6,2.405);
TGeoVolume *PTRL = gGeoManager->MakeTrd1("PTRL",med18,0,14.9,0.4,2.375);
TGeoVolume *ATRL = gGeoManager->MakeTrd1("ATRL",med1,0,15.7,0.4,2.375);
TGeoVolume *LTRL = gGeoManager->MakeTrd1("LTRL",med3,0,16.05,0.6,2.375);
TGeoVolume *CASA = gGeoManager->MakeBox("CASA",med3,21.45,0.6,20.55);
TGeoVolume *STRP = gGeoManager->MakeBox("STRP",med1,21.45,0.6,20.55);
TGeoVolume *SID1 = gGeoManager->MakeBox("SID1",med10,20.3,0.4,19.4);
TGeoVolume *PLA1 = gGeoManager->MakeBox("PLA1",med18,21.1,0.4,20.2);
TGeoVolume *STP1 = gGeoManager->MakeTrap("STP1",med18,16.1,7.361413,0,0.4,0,0,0,0.4,4.16,4.16,0);
TGeoVolume *STP2 = gGeoManager->MakeTrap("STP2",med18,2.4,20.55605,0,0.4,0,0,0,0.4,1.8,1.8,0);
TGeoVolume *STP3 = gGeoManager->MakeTrap("STP3",med18,0.9,58.17256,0,0.4,1.8,1.8,0,0.4,4.7,4.7,0);
TGeoVolume *STA1 = gGeoManager->MakeTrap("STA1",med1,16.5,7.355684,0,0.4,0,0,0,0.4,4.26,4.26,0);
TGeoVolume *STA2 = gGeoManager->MakeTrap("STA2",med1,2.8,21.44774,0,0.4,0,0,0,0.4,2.2,2.2,0);
TGeoVolume *STA3 = gGeoManager->MakeTrap("STA3",med1,0.9,58.17256,0,0.4,2.2,2.2,0,0.4,5.1,5.1,0);
TGeoVolume *STL1 = gGeoManager->MakeTrap("STL1",med3,16.675,7.355378,0,0.6,0,0,0,0.6,4.305,4.305,0);
TGeoVolume *STL2 = gGeoManager->MakeTrap("STL2",med3,2.8,21.44774,0,0.6,0,0,0,0.6,2.2,2.2,0);
TGeoVolume *STL3 = gGeoManager->MakeTrap("STL3",med3,1.075,58.18079,0,0.6,2.15,2.15,0,0.6,5.615,5.615,0);
TGeoVolume *C1D1 = gGeoManager->MakeTrap("C1D1",med10,9.075,17.37456,180,0.4,17.1515,17.1515,0,0.4,15.99778,15.99778,0);
TGeoVolume *C2D1 = gGeoManager->MakeTrap("C2D1",med10,9.075,14.89904,180,0.4,14.5515,14.5515,0,0.4,14.24778,14.24778,0);
TGeoVolume *CAR1 = gGeoManager->MakeTrap("CAR1",med1,10.175,17.37456,180,0.55,18.37594,18.37594,0,0.55,17.08238,17.08238,0);
TGeoVolume *CR1P = gGeoManager->MakeTrap("CR1P",med18,9.974999,17.37456,180,0.4,18.15331,18.15331,0,0.4,16.88518,16.88518,0);
TGeoVolume *CAR2 = gGeoManager->MakeTrap("CAR2",med1,10.175,14.89904,180,0.55,15.70831,15.70831,0,0.55,15.36778,15.36778,0);
TGeoVolume *CR2P = gGeoManager->MakeTrap("CR2P",med18,9.974999,14.89904,180,0.4,15.49798,15.49798,0,0.4,15.16415,15.16415,0);
TGeoVolume *VSN1 = gGeoManager->MakeTrap("VSN1",med3,3.3,14.05436,0,0.4,0,0,0,0.4,3.297782,3.297782,0);
TGeoVolume *VSN2 = gGeoManager->MakeTrap("VSN2",med18,0.9,63.27491,0,0.4,0,0,0,0.4,2.225,2.225,0);
TGeoVolume *VPN2 = gGeoManager->MakeTrap("VPN2",med1,0.7358874,63.27491,0,0.55,0,0,0,0.55,1.819277,1.819277,0);
TGeoVolume *VPN1 = gGeoManager->MakeTrap("VPN1",med3,4.214088,14.05436,0,0.4,0,0,0,0.4,4.211256,4.211256,0);
TGeoVolume *VAN1 = gGeoManager->MakeTrap("VAN1",med3,4.417219,14.05436,0,0.55,0,0,0,0.55,4.41425,4.41425,0);
TGeoVolume *VAN2 = gGeoManager->MakeTrap("VAN2",med3,0.6994181,63.27491,0,0.55,0,0,0,0.55,1.729117,1.729117,0);
TGeoVolume *CARD = gGeoManager->MakeBox("CARD",med3,27,22.8,12.35);
TGeoVolume *LEGB = gGeoManager->MakeBox("LEGB",med1,2.15,3.575,11.85);
TGeoVolume *LEG1 = gGeoManager->MakeTrap("LEG1",med3,0.65,0,0,0.15,6.85,6.85,0,0.15,10.85,10.85,0);
TGeoVolume *LEG2 = gGeoManager->MakeBox("LEG2",med3,0.65,1.65,11.35);
TGeoVolume *LEG3 = gGeoManager->MakeBox("LEG3",med3,0.1,1.3,0.325);
TGeoVolume *LEG4 = gGeoManager->MakeBox("LEG4",med3,0.65,1.625,11.85);
TGeoVolume *LEG5 = gGeoManager->MakeBox("LEG5",med3,1.125,2.575,11.85);
TGeoVolume *LEG6 = gGeoManager->MakeBox("LEG6",med3,0.1,0.55,11.2);
TGeoVolume *LEG7 = gGeoManager->MakeBox("LEG7",med3,1.1,0.75,3.25);
TGeoVolume *LEG8 = gGeoManager->MakeBox("LEG8",med3,1.1,0.75,4.35);
TGeoVolume *LEG9 = gGeoManager->MakeBox("LEG9",med3,1.1,0.75,3.25);
TGeoVolume *TPLT = gGeoManager->MakeBox("TPLT",med1,27,22.8,0.5);
TGeoVolume *TOPC = gGeoManager->MakeBox("TOPC",med3,20.4,16,0.5);
TGeoVolume *TH11 = gGeoManager->MakeBox("TH11",med3,2.8,3.2,0.5);
TGeoVolume *TH12 = gGeoManager->MakeBox("TH12",med3,2.8,5.3,0.5);
TGeoVolume *TH21 = gGeoManager->MakeBox("TH21",med3,1.7,3,0.5);
TGeoVolume *TH22 = gGeoManager->MakeBox("TH22",med3,4.9,3,0.5);
TGeoVolume *TOPT = gGeoManager->MakeTrap("TOPT",med3,0.5,0,0,2.25,2.25,0,-26.565,2.25,2.25,0,-26.565);
 TGeoVolume *TOHO = gGeoManager->MakeTube("TOHO",med3,0.0,0.7,0.5);/// INNER RADIUS=OUTER RADIUS PROBLEM!!!
TGeoVolume *MGSC = gGeoManager->MakeBox("MGSC",med10,16,15.4,0.12456);
TGeoVolume *MGSH = gGeoManager->MakeBox("MGSH",med3,9.8,8,0.12456);
TGeoVolume *SPEB = gGeoManager->MakeBox("SPEB",med3,15,14.4,22.615);
TGeoVolume *MGFR = gGeoManager->MakeBox("MGFR",med1,15,14.4,4.45);
TGeoVolume *MGPL = gGeoManager->MakeBox("MGPL",med5,12,11.4,4);
TGeoVolume *MGPI = gGeoManager->MakeBox("MGPI",med3,8.07,6.57,4);
TGeoVolume *TRPB = gGeoManager->MakeBox("TRPB",med1,10.49,12.15,0.365);
TGeoVolume *TPAS = gGeoManager->MakeBox("TPAS",med3,8.2,9.9,0.365);
TGeoVolume *TPAI = gGeoManager->MakeBox("TPAI",med1,8.144,1.25,0.5000000E-01);
TGeoVolume *TRSL = gGeoManager->MakeBox("TRSL",med12,2.6665,3.5,0.1500000E-01);
TGeoVolume *THBP = gGeoManager->MakeBox("THBP",med17,2.6665,2.75,0.1500000E-01);
TGeoVolume *TSPA = gGeoManager->MakeBox("TSPA",med12,2.596,3.413,0.1500000E-01);
TGeoVolume *TRCP = gGeoManager->MakeBox("TRCP",med9,0.3500000E-01,9.9,0.25);
TGeoVolume *TBAL = gGeoManager->MakeBox("TBAL",med1,1.49,2.25,0.365);
TGeoVolume *MGPA = gGeoManager->MakeBox("MGPA",med1,8.1,6.6,4);
TGeoVolume *TPGA = gGeoManager->MakeBox("TPGA",med3,10.29,10.65,0.4000000E-01);
TGeoVolume *TPGI = gGeoManager->MakeBox("TPGI",med3,8.07,6.57,0.1500000E-01);
TGeoVolume *TPGU = gGeoManager->MakeBox("TPGU",med3,10.49,12.15,0.1000000E-01);
TGeoVolume *TPGD = gGeoManager->MakeBox("TPGD",med3,12,11.4,0.5000000E-02);
TGeoVolume *CALB = gGeoManager->MakeBox("CALB",med3,23.2,23.2,10.589);
//  CALB->SetVisibility(-2);
//  CALB->VisibleDaughters(kFALSE);
TGeoVolume *CALS = gGeoManager->MakeBox("CALS",med1,24.2,24.2,10.639);
// CALS->VisibleDaughters(kFALSE);
// CALS->SetVisibility(kFALSE);
TGeoVolume *CAPL = gGeoManager->MakeBox("CAPL",med3,12.3,12.3,0.1900000E-01);
TGeoVolume *CANS = gGeoManager->MakeBox("CANS",med3,12.3,12.3,0.7000000E-01);
////TGeoVolume *CAPD = gGeoManager->MakeBox("CAPD",med3,12.3,12.3,0.7000000E-01);/////NOT INSERTED BELOW/////
TGeoVolume *CASI = gGeoManager->MakeBox("CASI",med11,3.904,3.904,0.1900000E-01);
TGeoVolume *C10C = gGeoManager->MakeBox("C10C",med17,12.3,12.3,0.6000000E-01);
TGeoVolume *CAAB = gGeoManager->MakeBox("CAAB",med15,12.3,12.3,0.1315);
////TGeoVolume *CAAD = gGeoManager->MakeBox("CAAD",med1,12.3,12.3,0.133);/////NOT INSERTED BELOW/////
TGeoVolume *CAKA = gGeoManager->MakeBox("CAKA",med16,12.3,12.3,0.2500000E-02);
TGeoVolume *CAKP = gGeoManager->MakeBox("CAKP",med6,12.3,12.3,0.2500000E-02);
TGeoVolume *CAGL = gGeoManager->MakeBox("CAGL",med11,12.3,12.3,0.5000000E-02);
TGeoVolume *NDBO = gGeoManager->MakeBox("NDBO",med3,27.5,30,7.5);
TGeoVolume *NDBX = gGeoManager->MakeBox("NDBX",med1,21.45,21.45,7);
TGeoVolume *NDCD = gGeoManager->MakeBox("NDCD",med21,21.25,21.25,6.9);
TGeoVolume *NDBI = gGeoManager->MakeBox("NDBI",med3,21.2,21.2,6.875);
TGeoVolume *NDTU = gGeoManager->MakeTube("NDTU",med5,0,0.925,10);
TGeoVolume *NDTI = gGeoManager->MakeTube("NDTI",med22,0,0.92,10);
TGeoVolume *NDPB = gGeoManager->MakeBox("NDPB",med23,21.2,21.2,1);
TGeoVolume *NDCO = gGeoManager->MakeBox("NDCO",med1,27.5,30,0.5);
TGeoVolume *NDBS = gGeoManager->MakeBox("NDBS",med1,15,4.275,7);
TGeoVolume *NDSS = gGeoManager->MakeBox("NDSS",med3,14.8,4.075,6.8);
TGeoVolume *NDCI = gGeoManager->MakeBox("NDCI",med3,21.2,11.3,0.325);
TGeoVolume *NDCM = gGeoManager->MakeBox("NDCM",med3,21.2,4.25,0.325);
TGeoVolume *NDCE = gGeoManager->MakeBox("NDCE",med3,14.6,2.875,0.325);
TGeoVolume *NDSI = gGeoManager->MakeBox("NDSI",med3,1,7.26,0.325);
TGeoVolume *NDSM = gGeoManager->MakeBox("NDSM",med3,1,5.8,0.325);
TGeoVolume *NDSE = gGeoManager->MakeBox("NDSE",med3,4.2,1.05,0.325);

//-----------List of Nodes--------------

gGeoManager->SetTopVolume(PAME);
 PAME->AddNode(SHEL,1,new TGeoTranslation(0,0,65.939));
 PAME->AddNode(TSPH,1,new TGeoTranslation(0,0,-131.7581));
 PAME->AddNode(MSHE,1,new TGeoTranslation(0,0,7.689003));
 PAME->AddNode(BSPH,1,new TGeoTranslation(0,0,-12.311));
 PAME->AddNode(S1__,1,new TGeoTranslation(0,0,102.8866));
  S1__->AddNode(S1A_,0,gGeoIdentity);
   S1A_->AddNode(POL2,1,new TGeoTranslation(0,0,-1.1546));
   S1A_->AddNode(S12M,1,new TGeoTranslation(0,-13.7592,-0.6022999));
   S12M->AddNode(S12X,1,gGeoIdentity);
   S1A_->AddNode(S12M,2,new TGeoTranslation(0,-8.2546,-0.6022999));
   S1A_->AddNode(S12M,3,new TGeoTranslation(0,-2.75,-0.6022999));
   S1A_->AddNode(S12M,4,new TGeoTranslation(0,2.754601,-0.6022999));
   S1A_->AddNode(S12M,5,new TGeoTranslation(0,8.2592,-0.6022999));
   S1A_->AddNode(S12M,6,new TGeoTranslation(0,13.7638,-0.6022999));
   S1A_->AddNode(S11M,1,new TGeoTranslation(-17.8638,0,0.1023));
    S11M->AddNode(S11Y,1,gGeoIdentity);
   S1A_->AddNode(S11M,2,new TGeoTranslation(-12.7592,0,0.1023));
   S1A_->AddNode(S11M,3,new TGeoTranslation(-7.6546,0,0.1023));
   S1A_->AddNode(S11M,4,new TGeoTranslation(-2.55,0,0.1023));
   S1A_->AddNode(S11M,5,new TGeoTranslation(2.5546,0,0.1023));
   S1A_->AddNode(S11M,6,new TGeoTranslation(7.6592,0,0.1023));
   S1A_->AddNode(S11M,7,new TGeoTranslation(12.7638,0,0.1023));
   S1A_->AddNode(S11M,8,new TGeoTranslation(17.8684,0,0.1023));
   S1A_->AddNode(POL1,1,new TGeoTranslation(0,0,0.9046));
 PAME->AddNode(CARD,1,new TGeoTranslation(0,0,87.439));
  CARD->AddNode(CAR1,1,new TGeoCombiTrans(-3.91289,-13.17068,0.1509358,rot11));
   CAR1->AddNode(VAN1,1,new TGeoTranslation(-16.95761,0,5.757782));
   CAR1->AddNode(VAN2,1,new TGeoTranslation(-11.09758,0,9.475582));
   CAR1->AddNode(CR1P,1,new TGeoTranslation(0.3790001E-02,0,0));
    CR1P->AddNode(VPN1,1,new TGeoTranslation(-16.84998,0,5.760911));
    CR1P->AddNode(VPN2,1,new TGeoTranslation(-11.22606,0,9.239112));
    CR1P->AddNode(C1D1,1,new TGeoTranslation(0.1705500E-01,0,0));
     C1D1->AddNode(VSN1,1,new TGeoTranslation(-16.36562,0,5.775));
     C1D1->AddNode(VSN2,1,new TGeoTranslation(-11.80423,0,8.175));
  CARD->AddNode(CAR1,2,new TGeoCombiTrans(3.91289,13.17068,0.1509358,rot12));
  CARD->AddNode(CAR2,1,new TGeoCombiTrans(15.79685,-4.187448,0.9491571E-02,rot14));
   CAR2->AddNode(VAN1,2,new TGeoTranslation(-14.7665,0,5.757782));
   CAR2->AddNode(VAN2,2,new TGeoTranslation(-8.906463,0,9.475582));
   CAR2->AddNode(CR2P,1,new TGeoTranslation(0.8603846E-03,0,0));
    CR2P->AddNode(VPN1,2,new TGeoTranslation(-14.66179,0,5.760911));
    CR2P->AddNode(VPN2,2,new TGeoTranslation(-9.037874,0,9.239112));
    CR2P->AddNode(C2D1,1,new TGeoTranslation(0.3871730E-02,0,0));
     C2D1->AddNode(VSN1,2,new TGeoTranslation(-14.19062,0,5.775));
     C2D1->AddNode(VSN2,2,new TGeoTranslation(-9.629226,0,8.175));
  CARD->AddNode(CAR2,2,new TGeoCombiTrans(-15.79685,4.187448,0.9491571E-02,rot13));
  CARD->AddNodeOverlap(LEGB,1,new TGeoTranslation(-21.05,-18.525,-0.5));
   LEGB->AddNode(LEG1,1,new TGeoCombiTrans(-1.5,-3.425,0,rot7));
   LEGB->AddNode(LEG1,2,new TGeoCombiTrans(-1.5,0.175,0,rot7));
   LEGB->AddNode(LEG2,1,new TGeoTranslation(-1.5,-1.625,0));
   LEGB->AddNode(LEG3,1,new TGeoTranslation(-0.5500001,2.275,11.525));
   LEGB->AddNode(LEG3,2,new TGeoTranslation(-0.5500001,2.275,-11.525));
   LEGB->AddNode(LEG4,1,new TGeoTranslation(-1.5,1.95,0));
   LEGB->AddNode(LEG5,1,new TGeoTranslation(1.025,1,0));
   LEGB->AddNode(LEG6,1,new TGeoTranslation(-0.7500001,3.025,0));
   LEGB->AddNode(LEG7,1,new TGeoTranslation(0.6500001,-2.825,8));
   LEGB->AddNode(LEG8,1,new TGeoTranslation(0.6500001,-2.825,0));
   LEGB->AddNode(LEG9,1,new TGeoTranslation(0.6500001,-2.825,-8));
  CARD->AddNodeOverlap(LEGB,2,new TGeoCombiTrans(-21.05,18.525,-0.5,rot10));
  CARD->AddNodeOverlap(LEGB,3,new TGeoCombiTrans(21.05,18.525,-0.5,rot4));
  CARD->AddNodeOverlap(LEGB,4,new TGeoCombiTrans(21.05,-18.525,-0.5,rot9));
  CARD->AddNode(TPLT,1,new TGeoTranslation(0,0,11.85));
   TPLT->AddNode(TOPC,1,gGeoIdentity);
   TPLT->AddNode(TH11,1,new TGeoTranslation(-23.6,14.4,0));
   TPLT->AddNode(TH11,2,new TGeoTranslation(-23.6,-14.4,0));
   TPLT->AddNode(TH11,3,new TGeoTranslation(23.6,14.4,0));
   TPLT->AddNode(TH11,4,new TGeoTranslation(23.6,-14.4,0));
   TPLT->AddNode(TH12,1,new TGeoTranslation(-23.6,5.5,0));
   TPLT->AddNode(TH12,2,new TGeoTranslation(-23.6,-5.5,0));
   TPLT->AddNode(TH12,3,new TGeoTranslation(23.6,5.5,0));
   TPLT->AddNode(TH12,4,new TGeoTranslation(23.6,-5.5,0));
   TPLT->AddNode(TH21,1,new TGeoTranslation(-17.2,19.4,0));
   TPLT->AddNode(TH21,2,new TGeoTranslation(-17.2,-19.4,0));
   TPLT->AddNode(TH21,3,new TGeoTranslation(17.2,19.4,0));
   TPLT->AddNode(TH21,4,new TGeoTranslation(17.2,-19.4,0));
   TPLT->AddNode(TH22,1,new TGeoTranslation(-10.2,19.4,0));
   TPLT->AddNode(TH22,2,new TGeoTranslation(-10.2,-19.4,0));
   TPLT->AddNode(TH22,3,new TGeoTranslation(10.2,19.4,0));
   TPLT->AddNode(TH22,4,new TGeoTranslation(10.2,-19.4,0));
   TPLT->AddNode(TH22,5,new TGeoTranslation(0,19.4,0));
   TPLT->AddNode(TH22,6,new TGeoTranslation(0,-19.4,0));
   TPLT->AddNode(TOPT,1,new TGeoTranslation(-25.875,-20.55,0));
   TPLT->AddNode(TOPT,2,new TGeoCombiTrans(-25.875,20.55,0,rot10));
   TPLT->AddNode(TOPT,3,new TGeoCombiTrans(25.875,20.55,0,rot4));
   TPLT->AddNode(TOPT,4,new TGeoCombiTrans(25.875,-20.55,0,rot9));
    TPLT->AddNode(TOHO,1,new TGeoTranslation(20.1,18,0));
    TPLT->AddNode(TOHO,2,new TGeoTranslation(-20.1,18,0));
   TPLT->AddNode(TOHO,3,new TGeoTranslation(-20.1,-18,0));
   TPLT->AddNode(TOHO,4,new TGeoTranslation(20.1,-18,0));
  CARD->AddNode(MGSC,1,new TGeoTranslation(0,0,-12.22544));
   MGSC->AddNode(MGSH,1,gGeoIdentity);
 PAME->AddNode(TPLA,1,new TGeoTranslation(0,0,73.489));
  TPLA->AddNode(TPTL,1,new TGeoTranslation(0,0,-1.35));
   TPTL->AddNode(TPCV,1,gGeoIdentity);
  TPLA->AddNode(S2__,1,new TGeoTranslation(0,0,-0.3524001));
   S2__->AddNode(S2A_,1,gGeoIdentity);
    S2A_->AddNode(S22M,1,new TGeoTranslation(-4.5,0,-0.4523));
     S22M->AddNode(S22Y,1,gGeoIdentity);
    S2A_->AddNode(S22M,2,new TGeoTranslation(4.5046,0,-0.4523));
    S2A_->AddNode(S21M,1,new TGeoTranslation(0,-3.75,0.5230001E-01));
     S21M->AddNode(S21X,1,gGeoIdentity);
    S2A_->AddNode(S21M,2,new TGeoTranslation(0,3.7546,0.5230001E-01));
    S2A_->AddNode(POLY,1,new TGeoTranslation(0,0,0.5046));
  TPLA->AddNode(TPTM,1,new TGeoTranslation(-19.75,-18.8,-0.3524001));
  TPLA->AddNode(TPTM,2,new TGeoTranslation(-19.75,18.8,-0.3524001));
  TPLA->AddNode(TPTM,3,new TGeoTranslation(19.75,-18.8,-0.3524001));
  TPLA->AddNode(TPTM,4,new TGeoTranslation(19.75,18.8,-0.3524001));
  TPLA->AddNode(CATA,1,new TGeoCombiTrans(0,0,1,rot2));
   CATA->AddNode(ATBB,1,gGeoIdentity);
    ATBB->AddNode(PLA2,1,gGeoIdentity);
     PLA2->AddNode(TOP1,1,gGeoIdentity);
      TOP1->AddNode(PTBM,1,gGeoIdentity);
      TOP1->AddNode(PTBC,1,new TGeoTranslation(-21.875,0,20.4575));
      TOP1->AddNode(PTBC,2,new TGeoTranslation(21.875,0,20.4575));
      TOP1->AddNode(PTBC,3,new TGeoTranslation(-21.875,0,-20.4575));
      TOP1->AddNode(PTBC,4,new TGeoTranslation(21.875,0,-20.4575));
      TOP1->AddNode(PTRT,1,new TGeoTranslation(0,0,23.61));
      TOP1->AddNode(PTRB,1,new TGeoTranslation(0,0,-23.61));
      TOP1->AddNode(PTRL,1,new TGeoCombiTrans(-24.475,0,0,rot7));
      TOP1->AddNode(PTRL,2,new TGeoCombiTrans(24.475,0,0,rot8));
     PLA2->AddNode(ATBM,1,gGeoIdentity);
     PLA2->AddNode(ATBC,1,new TGeoTranslation(-22.675,0,21.2575));
     PLA2->AddNode(ATBC,2,new TGeoTranslation(22.675,0,21.2575));
     PLA2->AddNode(ATBC,3,new TGeoTranslation(-22.675,0,-21.2575));
     PLA2->AddNode(ATBC,4,new TGeoTranslation(22.675,0,-21.2575));
     PLA2->AddNode(ATRT,1,new TGeoTranslation(0,0,24.41));
     PLA2->AddNode(ATRB,1,new TGeoTranslation(0,0,-24.41));
     PLA2->AddNode(ATRL,1,new TGeoCombiTrans(-25.275,0,0,rot7));
     PLA2->AddNode(ATRL,2,new TGeoCombiTrans(25.275,0,0,rot8));
    ATBB->AddNode(LTBM,1,gGeoIdentity);
    ATBB->AddNode(LTBC,1,new TGeoTranslation(-23.025,0,21.6075));
    ATBB->AddNode(LTBC,2,new TGeoTranslation(23.025,0,21.6075));
    ATBB->AddNode(LTBC,3,new TGeoTranslation(-23.025,0,-21.6075));
    ATBB->AddNode(LTBC,4,new TGeoTranslation(23.025,0,-21.6075));
    ATBB->AddNode(LTRT,1,new TGeoTranslation(0,0,24.76));
    ATBB->AddNode(LTRB,1,new TGeoTranslation(0,0,-24.76));
    ATBB->AddNode(LTRL,1,new TGeoCombiTrans(-25.625,0,0,rot7));
    ATBB->AddNode(LTRL,2,new TGeoCombiTrans(25.625,0,0,rot8));
  TPLA->AddNode(TPTU,1,new TGeoTranslation(-20.65,-20.15,1));
  TPLA->AddNode(TPTU,2,new TGeoTranslation(-20.65,20.15,1));
  TPLA->AddNode(TPTU,3,new TGeoTranslation(20.65,-20.15,1));
  TPLA->AddNode(TPTU,4,new TGeoTranslation(20.65,20.15,1));
  PAME->AddNode(CASA,1,new TGeoTranslation(8.872,-17.215,47.174));
  CASA->AddNode(STRP,1,gGeoIdentity);
   STRP->AddNode(PLA1,1,gGeoIdentity);
    PLA1->AddNode(SID1,1,gGeoIdentity);
     SID1->AddNode(STP1,1,new TGeoCombiTrans(18.22,0,-3.3,rot5));
     SID1->AddNode(STP2,1,new TGeoCombiTrans(19.4,0,15.2,rot4));
     SID1->AddNode(STP3,1,new TGeoCombiTrans(17.05,0,18.5,rot4));
    PLA1->AddNode(STA1,1,new TGeoCombiTrans(18.97,0,-3.7,rot5));
    PLA1->AddNode(STA2,1,new TGeoCombiTrans(20,0,15.6,rot4));
    PLA1->AddNode(STA3,1,new TGeoCombiTrans(17.45,0,19.3,rot4));
   STRP->AddNode(STL1,1,new TGeoCombiTrans(19.2975,0,-3.875,rot5));
   STRP->AddNode(STL2,1,new TGeoCombiTrans(20.35,0,15.6,rot4));
   STRP->AddNode(STL3,1,new TGeoCombiTrans(17.5675,0,19.475,rot4));
   PAME->AddNode(CASA,2,new TGeoCombiTrans(17.9285,6.305,47.174,rot1));
   PAME->AddNode(CASA,3,new TGeoCombiTrans(-5.5095,17.215,47.174,rot4));
   PAME->AddNode(CASA,4,new TGeoCombiTrans(-17.9285,-10.195,47.174,rot6));
   PAME->AddNode(SPEB,1,new TGeoTranslation(0,0,49.274));
   SPEB->AddNode(MGFR,1,new TGeoTranslation(0,0,18.165));
   MGFR->AddNode(TPGD,1,new TGeoTranslation(0,0,-4.445));
   MGFR->AddNode(TPGI,1,new TGeoTranslation(0,0,-4.425));
   MGFR->AddNode(MGPL,1,new TGeoTranslation(0,0,-0.4099998));
    MGPL->AddNode(MGPA,1,gGeoIdentity);
     MGPA->AddNode(MGPI,1,gGeoIdentity);
   MGFR->AddNode(TPGI,2,new TGeoTranslation(0,0,3.605));
   MGFR->AddNode(TPGA,1,new TGeoTranslation(0,-0.75,3.66));
   MGFR->AddNode(TRPB,1,new TGeoTranslation(0,-2.25,4.065));
    TRPB->AddNode(TPAS,4,new TGeoTranslation(0,-0.75,0));
     TPAS->AddNode(TRCP,1,new TGeoTranslation(-8.1075,0,0.1500001E-01));
     TPAS->AddNode(TRCP,2,new TGeoTranslation(-2.7025,0,0.1500001E-01));
     TPAS->AddNode(TRCP,3,new TGeoTranslation(2.7025,0,0.1500001E-01));
     TPAS->AddNode(TRCP,4,new TGeoTranslation(8.1075,0,0.1500001E-01));
     TPAS->AddNode(TRSL,1,new TGeoTranslation(-5.405,6.252,0.1500001E-01));
      TRSL->AddNode(TSPA,1,gGeoIdentity);
     TPAS->AddNode(TRSL,2,new TGeoTranslation(0.1164153E-08,6.252,0.1500001E-01));
     TPAS->AddNode(TRSL,3,new TGeoTranslation(5.405,6.252,0.1500001E-01));
     TPAS->AddNode(TRSL,4,new TGeoTranslation(-5.405,-0.7500004,0.1500001E-01));
     TPAS->AddNode(TRSL,5,new TGeoTranslation(0.1164153E-08,-0.7500004,0.1500001E-01));
     TPAS->AddNode(TRSL,6,new TGeoTranslation(5.405,-0.7500004,0.1500001E-01));
     TPAS->AddNode(THBP,1,new TGeoTranslation(-5.405,-7.0015,0.1500001E-01));
     TPAS->AddNode(THBP,2,new TGeoTranslation(0.1164153E-08,-7.0015,0.1500001E-01));
     TPAS->AddNode(THBP,3,new TGeoTranslation(5.405,-7.0015,0.1500001E-01));
     TPAS->AddNode(TPAI,4,new TGeoTranslation(0,-8.65,0.315));
   MGFR->AddNode(TPGU,2,new TGeoTranslation(0,-2.25,4.44));
  SPEB->AddNode(MGFR,2,new TGeoTranslation(0,0,9.265001));
  SPEB->AddNode(MGFR,3,new TGeoTranslation(0,0,0.3650017));
  SPEB->AddNode(MGFR,4,new TGeoTranslation(0,0,-8.534998));
  SPEB->AddNode(MGFR,5,new TGeoTranslation(0,0,-17.435));
  SPEB->AddNode(TRPB,2,new TGeoCombiTrans(0,2.25,-22.25,rot10));
  SPEB->AddNode(TBAL,1,new TGeoTranslation(5.4,-12.15,-22.25));
  SPEB->AddNode(TBAL,2,new TGeoTranslation(-5.4,-12.15,-22.25));
 PAME->AddNode(S3__,1,new TGeoTranslation(0,0,25.3159));
  S3__->AddNode(S32M,1,new TGeoTranslation(0,-5.0069,-0.42845));
   S32M->AddNode(S32X,1,new TGeoTranslation(0,-0.1149917E-02,-0.1150006E-02));
  S3__->AddNode(S32M,2,new TGeoTranslation(0,0,-0.42845));
  S3__->AddNode(S32M,3,new TGeoTranslation(0,5.0069,-0.42845));
  S3__->AddNode(S31M,1,new TGeoTranslation(-6.006899,0,0.42845));
   S31M->AddNode(S31Y,1,new TGeoTranslation(-0.1149917E-02,0,-0.1150006E-02));
  S3__->AddNode(S31M,2,new TGeoTranslation(0.4768372E-06,0,0.42845));
  S3__->AddNode(S31M,3,new TGeoTranslation(6.0069,0,0.42845));
  PAME->AddNode(CALS,1,new TGeoTranslation(0,0,13.05));
  CALS->AddNode(CALB,1,new TGeoTranslation(0,0,0.5000019E-01));
   CALB->AddNode(CAPL,1,new TGeoTranslation(0.1,-0.5000000E-01,9.875999));
    CAPL->AddNode(CASI,1,new TGeoTranslation(-8.05,-8.05,0));
     TGeoVolume *CAST = CASI->Divide("CAST",2,32,-3.904,0.244);
    CAPL->AddNode(CASI,2,new TGeoTranslation(0,-8.05,0));
    CAPL->AddNode(CASI,3,new TGeoTranslation(8.05,-8.05,0));
    CAPL->AddNode(CASI,4,new TGeoTranslation(-8.05,0,0));
    CAPL->AddNode(CASI,5,gGeoIdentity);
    CAPL->AddNode(CASI,6,new TGeoTranslation(8.05,0,0));
    CAPL->AddNode(CASI,7,new TGeoTranslation(-8.05,8.05,0));
    CAPL->AddNode(CASI,8,new TGeoTranslation(0,8.05,0));
    CAPL->AddNode(CASI,9,new TGeoTranslation(8.05,8.05,0));
   CALB->AddNode(CANS,1,new TGeoTranslation(0,-0.1,9.787));
    CANS->AddNode(CAKA,1,new TGeoTranslation(0,0,-0.6750000E-01));
    CANS->AddNode(C10C,1,new TGeoTranslation(0,0,-0.5000004E-02));
    CANS->AddNode(CAGL,1,new TGeoTranslation(0,0,0.5999999E-01));
    CANS->AddNode(CAKP,1,new TGeoTranslation(0,0,0.6750000E-01));
   CALB->AddNode(CAAB,1,new TGeoTranslation(0,-0.1,9.5855));
   CALB->AddNode(CANS,2,new TGeoCombiTrans(0,-0.1,9.384,rot3));
   CALB->AddNode(CAPL,2,new TGeoCombiTrans(-0.5000000E-01,0,9.295,rot3));
   CALB->AddNode(CAPL,3,new TGeoTranslation(-0.1,-0.15,9.067));
   CALB->AddNode(CANS,3,new TGeoTranslation(0,-0.1,8.978001));
   CALB->AddNode(CAAB,2,new TGeoTranslation(0,-0.1,8.776501));
   CALB->AddNode(CANS,4,new TGeoCombiTrans(0,-0.1,8.575001,rot3));
   CALB->AddNode(CAPL,4,new TGeoCombiTrans(0.5000000E-01,-0.2,8.486001,rot3));
   CALB->AddNode(CAPL,5,new TGeoTranslation(0.1,-0.5000000E-01,8.058001));
   CALB->AddNode(CANS,5,new TGeoTranslation(0,-0.1,7.969));
   CALB->AddNode(CAAB,3,new TGeoTranslation(0,-0.1,7.7675));
   CALB->AddNode(CANS,6,new TGeoCombiTrans(0,-0.1,7.566,rot3));
   CALB->AddNode(CAPL,6,new TGeoCombiTrans(-0.5000000E-01,0,7.477,rot3));
   CALB->AddNode(CAPL,7,new TGeoTranslation(-0.1,-0.15,7.249));
   CALB->AddNode(CANS,7,new TGeoTranslation(0,-0.1,7.16));
   CALB->AddNode(CAAB,4,new TGeoTranslation(0,-0.1,6.9585));
   CALB->AddNode(CANS,8,new TGeoCombiTrans(0,-0.1,6.757,rot3));
   CALB->AddNode(CAPL,8,new TGeoCombiTrans(0.5000000E-01,-0.2,6.668,rot3));
   CALB->AddNode(CAPL,9,new TGeoTranslation(0.1,-0.5000000E-01,6.24));
   CALB->AddNode(CANS,9,new TGeoTranslation(0,-0.1,6.151));
   CALB->AddNode(CAAB,5,new TGeoTranslation(0,-0.1,5.9495));
   CALB->AddNode(CANS,10,new TGeoCombiTrans(0,-0.1,5.748,rot3));
   CALB->AddNode(CAPL,10,new TGeoCombiTrans(-0.5000000E-01,0,5.658999,rot3));
   CALB->AddNode(CAPL,11,new TGeoTranslation(-0.1,-0.15,5.430999));
   CALB->AddNode(CANS,11,new TGeoTranslation(0,-0.1,5.341999));
   CALB->AddNode(CAAB,6,new TGeoTranslation(0,-0.1,5.140499));
   CALB->AddNode(CANS,12,new TGeoCombiTrans(0,-0.1,4.938999,rot3));
   CALB->AddNode(CAPL,12,new TGeoCombiTrans(0.5000000E-01,-0.2,4.849999,rot3));
   CALB->AddNode(CAPL,13,new TGeoTranslation(0.1,-0.5000000E-01,4.421999));
   CALB->AddNode(CANS,13,new TGeoTranslation(0,-0.1,4.332999));
   CALB->AddNode(CAAB,7,new TGeoTranslation(0,-0.1,4.131499));
   CALB->AddNode(CANS,14,new TGeoCombiTrans(0,-0.1,3.929999,rot3));
   CALB->AddNode(CAPL,14,new TGeoCombiTrans(-0.5000000E-01,0,3.840999,rot3));
   CALB->AddNode(CAPL,15,new TGeoTranslation(-0.1,-0.15,3.612999));
   CALB->AddNode(CANS,15,new TGeoTranslation(0,-0.1,3.523999));
   CALB->AddNode(CAAB,8,new TGeoTranslation(0,-0.1,3.322499));
   CALB->AddNode(CANS,16,new TGeoCombiTrans(0,-0.1,3.120999,rot3));
   CALB->AddNode(CAPL,16,new TGeoCombiTrans(0.5000000E-01,-0.2,3.031999,rot3));
   CALB->AddNode(CAPL,17,new TGeoTranslation(0.1,-0.5000000E-01,2.603999));
   CALB->AddNode(CANS,17,new TGeoTranslation(0,-0.1,2.514999));
   CALB->AddNode(CAAB,9,new TGeoTranslation(0,-0.1,2.313499));
   CALB->AddNode(CANS,18,new TGeoCombiTrans(0,-0.1,2.111999,rot3));
   CALB->AddNode(CAPL,18,new TGeoCombiTrans(-0.5000000E-01,0,2.022999,rot3));
   CALB->AddNode(CAPL,19,new TGeoTranslation(-0.1,-0.15,1.794999));
   CALB->AddNode(CANS,19,new TGeoTranslation(0,-0.1,1.705999));
   CALB->AddNode(CAAB,10,new TGeoTranslation(0,-0.1,1.504499));
   CALB->AddNode(CANS,20,new TGeoCombiTrans(0,-0.1,1.302999,rot3));
   CALB->AddNode(CAPL,20,new TGeoCombiTrans(0.5000000E-01,-0.2,1.213999,rot3));
   CALB->AddNode(CAPL,21,new TGeoTranslation(0.1,-0.5000000E-01,0.7859992));
   CALB->AddNode(CANS,21,new TGeoTranslation(0,-0.1,0.6969992));
   CALB->AddNode(CAAB,11,new TGeoTranslation(0,-0.1,0.4954992));
   CALB->AddNode(CANS,22,new TGeoCombiTrans(0,-0.1,0.2939992,rot3));
   CALB->AddNode(CAPL,22,new TGeoCombiTrans(-0.5000000E-01,0,0.2049992,rot3));
   CALB->AddNode(CAPL,23,new TGeoTranslation(-0.1,-0.15,-0.2300080E-01));
   CALB->AddNode(CANS,23,new TGeoTranslation(0,-0.1,-0.1120008));
   CALB->AddNode(CAAB,12,new TGeoTranslation(0,-0.1,-0.3135008));
   CALB->AddNode(CANS,24,new TGeoCombiTrans(0,-0.1,-0.5150008,rot3));
   CALB->AddNode(CAPL,24,new TGeoCombiTrans(0.5000000E-01,-0.2,-0.6040008,rot3));
   CALB->AddNode(CAPL,25,new TGeoTranslation(0.1,-0.5000000E-01,-1.032001));
   CALB->AddNode(CANS,25,new TGeoTranslation(0,-0.1,-1.121001));
   CALB->AddNode(CAAB,13,new TGeoTranslation(0,-0.1,-1.322501));
   CALB->AddNode(CANS,26,new TGeoCombiTrans(0,-0.1,-1.524001,rot3));
   CALB->AddNode(CAPL,26,new TGeoCombiTrans(-0.5000000E-01,0,-1.613001,rot3));
   CALB->AddNode(CAPL,27,new TGeoTranslation(-0.1,-0.15,-1.841001));
   CALB->AddNode(CANS,27,new TGeoTranslation(0,-0.1,-1.930001));
   CALB->AddNode(CAAB,14,new TGeoTranslation(0,-0.1,-2.131501));
   CALB->AddNode(CANS,28,new TGeoCombiTrans(0,-0.1,-2.333001,rot3));
   CALB->AddNode(CAPL,28,new TGeoCombiTrans(0.5000000E-01,-0.2,-2.422001,rot3));
   CALB->AddNode(CAPL,29,new TGeoTranslation(0.1,-0.5000000E-01,-2.850001));
   CALB->AddNode(CANS,29,new TGeoTranslation(0,-0.1,-2.939001));
   CALB->AddNode(CAAB,15,new TGeoTranslation(0,-0.1,-3.140501));
   CALB->AddNode(CANS,30,new TGeoCombiTrans(0,-0.1,-3.342001,rot3));
   CALB->AddNode(CAPL,30,new TGeoCombiTrans(-0.5000000E-01,0,-3.431001,rot3));
   CALB->AddNode(CAPL,31,new TGeoTranslation(-0.1,-0.15,-3.659001));
   CALB->AddNode(CANS,31,new TGeoTranslation(0,-0.1,-3.748001));
   CALB->AddNode(CAAB,16,new TGeoTranslation(0,-0.1,-3.949501));
   CALB->AddNode(CANS,32,new TGeoCombiTrans(0,-0.1,-4.151,rot3));
   CALB->AddNode(CAPL,32,new TGeoCombiTrans(0.5000000E-01,-0.2,-4.240001,rot3));
   CALB->AddNode(CAPL,33,new TGeoTranslation(0.1,-0.5000000E-01,-4.668001));
   CALB->AddNode(CANS,33,new TGeoTranslation(0,-0.1,-4.757001));
   CALB->AddNode(CAAB,17,new TGeoTranslation(0,-0.1,-4.958501));
   CALB->AddNode(CANS,34,new TGeoCombiTrans(0,-0.1,-5.160001,rot3));
   CALB->AddNode(CAPL,34,new TGeoCombiTrans(-0.5000000E-01,0,-5.249001,rot3));
   CALB->AddNode(CAPL,35,new TGeoTranslation(-0.1,-0.15,-5.477001));
   CALB->AddNode(CANS,35,new TGeoTranslation(0,-0.1,-5.566001));
   CALB->AddNode(CAAB,18,new TGeoTranslation(0,-0.1,-5.767501));
   CALB->AddNode(CANS,36,new TGeoCombiTrans(0,-0.1,-5.969001,rot3));
   CALB->AddNode(CAPL,36,new TGeoCombiTrans(0.5000000E-01,-0.2,-6.058002,rot3));
   CALB->AddNode(CAPL,37,new TGeoTranslation(0.1,-0.5000000E-01,-6.486001));
   CALB->AddNode(CANS,37,new TGeoTranslation(0,-0.1,-6.575002));
   CALB->AddNode(CAAB,19,new TGeoTranslation(0,-0.1,-6.776502));
   CALB->AddNode(CANS,38,new TGeoCombiTrans(0,-0.1,-6.978002,rot3));
   CALB->AddNode(CAPL,38,new TGeoCombiTrans(-0.5000000E-01,0,-7.067002,rot3));
   CALB->AddNode(CAPL,39,new TGeoTranslation(-0.1,-0.15,-7.295002));
   CALB->AddNode(CANS,39,new TGeoTranslation(0,-0.1,-7.384002));
   CALB->AddNode(CAAB,20,new TGeoTranslation(0,-0.1,-7.585502));
   CALB->AddNode(CANS,40,new TGeoCombiTrans(0,-0.1,-7.787002,rot3));
   CALB->AddNode(CAPL,40,new TGeoCombiTrans(0.5000000E-01,-0.2,-7.876002,rot3));
   CALB->AddNode(CAPL,41,new TGeoTranslation(0.1,-0.5000000E-01,-8.304003));
   CALB->AddNode(CANS,41,new TGeoTranslation(0,-0.1,-8.393003));
   CALB->AddNode(CAAB,21,new TGeoTranslation(0,-0.1,-8.594502));
   CALB->AddNode(CANS,42,new TGeoCombiTrans(0,-0.1,-8.796002,rot3));
   CALB->AddNode(CAPL,42,new TGeoCombiTrans(-0.5000000E-01,0,-8.885002,rot3));
   CALB->AddNode(CAPL,43,new TGeoTranslation(-0.1,-0.15,-9.113002));
   CALB->AddNode(CANS,43,new TGeoTranslation(0,-0.1,-9.202002));
   CALB->AddNode(CAAB,22,new TGeoTranslation(0,-0.1,-9.403502));
   CALB->AddNode(CANS,44,new TGeoCombiTrans(0,-0.1,-9.605001,rot3));
   CALB->AddNode(CAPL,44,new TGeoCombiTrans(0.5000000E-01,-0.2,-9.694001,rot3));
  PAME->AddNode(S4AL,1,new TGeoTranslation(0,0,1.811));
  S4AL->AddNode(S4__,1,gGeoIdentity);
  PAME->AddNode(NDBO,1,new TGeoTranslation(0,0,-6.289));
  NDBO->AddNode(NDBX,1,new TGeoTranslation(0,0,-0.5));
   NDBX->AddNode(NDCD,1,new TGeoTranslation(0,0,0.1000001));
    NDCD->AddNode(NDBI,1,new TGeoTranslation(0,0,0.2499991E-01));
     NDBI->AddNode(NDTU,1,new TGeoCombiTrans(-19.975,0,0.5000001E-01,rot2));
      NDTU->AddNode(NDTI,1,gGeoIdentity);
     NDBI->AddNode(NDTU,2,new TGeoCombiTrans(-17.625,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,3,new TGeoCombiTrans(-15.275,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,4,new TGeoCombiTrans(-12.925,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,5,new TGeoCombiTrans(-10.575,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,6,new TGeoCombiTrans(-8.224998,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,7,new TGeoCombiTrans(-5.874999,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,8,new TGeoCombiTrans(-3.524999,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,9,new TGeoCombiTrans(-1.174999,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,10,new TGeoCombiTrans(1.175001,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,11,new TGeoCombiTrans(3.525002,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,12,new TGeoCombiTrans(5.875001,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,13,new TGeoCombiTrans(8.225001,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,14,new TGeoCombiTrans(10.575,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,15,new TGeoCombiTrans(12.925,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,16,new TGeoCombiTrans(15.275,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,17,new TGeoCombiTrans(17.625,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,18,new TGeoCombiTrans(19.975,0,0.5000001E-01,rot2));
     NDBI->AddNode(NDTU,19,new TGeoCombiTrans(-19.975,0,3.9,rot2));
     NDBI->AddNode(NDTU,20,new TGeoCombiTrans(-17.625,0,3.9,rot2));
     NDBI->AddNode(NDTU,21,new TGeoCombiTrans(-15.275,0,3.9,rot2));
     NDBI->AddNode(NDTU,22,new TGeoCombiTrans(-12.925,0,3.9,rot2));
     NDBI->AddNode(NDTU,23,new TGeoCombiTrans(-10.575,0,3.9,rot2));
     NDBI->AddNode(NDTU,24,new TGeoCombiTrans(-8.224998,0,3.9,rot2));
     NDBI->AddNode(NDTU,25,new TGeoCombiTrans(-5.874999,0,3.9,rot2));
     NDBI->AddNode(NDTU,26,new TGeoCombiTrans(-3.524999,0,3.9,rot2));
     NDBI->AddNode(NDTU,27,new TGeoCombiTrans(-1.174999,0,3.9,rot2));
     NDBI->AddNode(NDTU,28,new TGeoCombiTrans(1.175001,0,3.9,rot2));
     NDBI->AddNode(NDTU,29,new TGeoCombiTrans(3.525002,0,3.9,rot2));
     NDBI->AddNode(NDTU,30,new TGeoCombiTrans(5.875001,0,3.9,rot2));
     NDBI->AddNode(NDTU,31,new TGeoCombiTrans(8.225001,0,3.9,rot2));
     NDBI->AddNode(NDTU,32,new TGeoCombiTrans(10.575,0,3.9,rot2));
     NDBI->AddNode(NDTU,33,new TGeoCombiTrans(12.925,0,3.9,rot2));
     NDBI->AddNode(NDTU,34,new TGeoCombiTrans(15.275,0,3.9,rot2));
     NDBI->AddNode(NDTU,35,new TGeoCombiTrans(17.625,0,3.9,rot2));
     NDBI->AddNode(NDTU,36,new TGeoCombiTrans(19.975,0,3.9,rot2));
     NDBI->AddNode(NDPB,1,new TGeoTranslation(0,0,-5.875));
     NDBI->AddNode(NDPB,2,new TGeoTranslation(0,0,-3.875));
     NDBI->AddNode(NDPB,3,new TGeoTranslation(0,0,-1.875));
     NDBI->AddNode(NDPB,4,new TGeoTranslation(0,0,1.975));
     NDBI->AddNode(NDPB,5,new TGeoTranslation(0,0,5.825));
  NDBO->AddNode(NDCO,1,new TGeoTranslation(0,0,7));
   NDCO->AddNode(NDCM,1,new TGeoTranslation(0,-16.95,0.175));
   NDCO->AddNode(NDCM,2,new TGeoTranslation(0,16.95,0.175));
   NDCO->AddNode(NDCI,1,new TGeoTranslation(0,0,0.175));
   NDCO->AddNode(NDCE,1,new TGeoTranslation(0,-25.475,0.175));
   NDCO->AddNode(NDCE,2,new TGeoTranslation(0,25.475,0.175));
   NDCO->AddNode(NDSM,1,new TGeoTranslation(-23.6,-14.6,0.175));
   NDCO->AddNode(NDSM,2,new TGeoTranslation(23.6,-14.6,0.175));
   NDCO->AddNode(NDSM,3,new TGeoTranslation(-23.6,14.6,0.175));
   NDCO->AddNode(NDSM,4,new TGeoTranslation(23.6,14.6,0.175));
   NDCO->AddNode(NDSI,1,new TGeoTranslation(-23.6,0,0.175));
   NDCO->AddNode(NDSI,2,new TGeoTranslation(23.6,0,0.175));
   NDCO->AddNode(NDSE,1,new TGeoTranslation(-20.4,-23.65,0.175));
   NDCO->AddNode(NDSE,2,new TGeoTranslation(20.4,-23.65,0.175));
   NDCO->AddNode(NDSE,3,new TGeoTranslation(-20.4,23.65,0.175));
   NDCO->AddNode(NDSE,4,new TGeoTranslation(20.4,23.65,0.175));
  NDBO->AddNode(NDBS,1,new TGeoTranslation(0,-25.725,-0.5));
   NDBS->AddNode(NDSS,1,gGeoIdentity);
  NDBO->AddNode(NDBS,2,new TGeoTranslation(0,25.725,-0.5));

  // close geometry
  gGeoManager->CloseGeometry();

  // notify VMC about Root geometry
  gMC->SetRootGeometry();
}


