#ifndef PAMVMCTOFSD_H
#define PAMVMCTOFSD_H
#include <iostream>

#include "PamVMCDetectorSD.h"

using std::cout;
using std::endl;

class PamVMCTofSD: public PamVMCDetectorSD{

    const char* cname;

public:
  PamVMCTofSD(char *dname):PamVMCDetectorSD("pHitData",dname,1000)
{
     cname=dname;
};


      virtual void FillHit(fin f,TVirtualMC *g){ 

  
     switch(f) {
    case ENTERING:
     
       CleanHit();
      FillVolID();
      InitHit();
    
    default:
     UpdateHit(g);
    
   cout<<"NEW HIT ENTERING OR  INSIDE "<<fnohit<<" in "<<cname<<" PDG="<<fhit.GetPDG()<<" GT "<<g->GetStack()->GetCurrentTrack()->T()<<" fTOF is: "<<fhit.GetTOF()<<endl;
     break;      
   }

  switch(f){
  case EXITING:
  ////  // Save hit if energy release is greater than zero 
    UpdateHit(g);
   if(fhit.GetEREL()){
  if(fdetID->FillVolID()){
    // AddGlobalTime(g);
    //cout<<"saving"<<fdetID->GetID()<<endl;
    cout<<"NEW HIT EXITING "<<fnohit<<" in "<<cname<<" PDG="<<fhit.GetPDG()<<" at"<<fhit.GetTOF()<<" GT  "<<g->GetStack()->GetCurrentTrack()->T() <<endl;
  	  SaveHit(cname);
  } else {
    cout << "TOF FillVolID false" <<endl; 
  }
    }
    break;
  default:
    break;
  }
  }
  
  ClassDef(PamVMCTofSD,1)

    };

#endif // PAMVMCTOFSD_H
