#ifndef PAMVMCCALOSD_H
#define PAMVMCCALOSD_H
#include <iostream>

#include "PamVMCDetectorSD.h"

#define NOCALHIT 4224

using std::cout;
using std::endl;

class PamVMCCaloSD: public PamVMCDetectorSD{
public:
  PamVMCCaloSD(): PamVMCDetectorSD("pHitData","CAST",NOCALHIT){
    //  for(Int_t i=0; i< NOCALHIT; ++i) CreateHit(i);
  }


  virtual void FillHit(fin f,TVirtualMC *g){ 

    switch(f) {
    case ENTERING:
      CleanHit();
      FillVolID();
      InitHit();
      
     
      //FillVolID();
      // cout<<"["<<GetViewID()<<"] ["<<GetPlaneID()<<"] ["<<GetStripID()<<"] "<<fhit.GetPOS()<<"\n";
       UpdateHit(g); 
    default:
       UpdateHit(g);
      break;      
    }

    switch(f){
    case EXITING:
       UpdateHit(g);
       // AddGlobalTime(g);
      // Save hit if energy release is greater than zero 
      if(fhit.GetEREL()){
	if(fdetID->FillVolID()){
	   SaveHit(fdetID->GetID( ));
	   //           cout<<fhit.GetPOS()<<"\n";
	} else {
	  cout << "Calorimeter FillVolID false" <<endl; 
	}
      }
      break;
    default:
      break;
    }
  }

  //virtual void UpdateHit(TVirtualMC *g){


  //}
  
  //   virtual void ClearHitColl(){
     //do nothing... for calorimerer only
  //    } 

  Int_t GetPlaneID(){
    return ((int)fhit.GetPOS()/192);
  }

  Int_t GetViewID(){
    return ((int)fhit.GetPOS()/96%2==0?0:1);
  }
  Int_t GetStripID(){
    return (fhit.GetPOS()%96);
  }

 

  ClassDef(PamVMCCaloSD,1)

};

#endif // PAMVMCCALOSD_H
