/**
 * \file RunGlue.cpp
 * \author Emiliano Mocchiutti
 * 
 * The file contains implementation of the methods to query the DB.
 */
//
#include <sstream>
#include <iostream>
//
#include <TFile.h>
#include <TTree.h>
#include <TTimeStamp.h>
#include <TTreeCloner.h>
#include <RunGlue.h>
//
ClassImp(RunGlue);
//
using namespace std;

RunGlue::RunGlue() {
  this->Clear();
}

RunGlue::RunGlue(TSQLServer *da, UInt_t ru, TString di, TString wrkdi) {
  fDBG = false;
  li = new PamLevel2();
  //  li = 0;
  this->Clear();
  dbc = da;
  run = ru;
  dir = di;
  //
  wd = gSystem->WorkingDirectory();  
  //
  outdir = wrkdi;
  if ( !strcmp(outdir.Data(),"") ) outdir = wd;
  fList = 0;
  if ( run ){
    runmode = true;
  } else {
    runmode = false;
    createlist = true;
  };
  fUpgrade = true;
  //
  //  lList = new TList();
  //
};

void RunGlue::Clear() {
  fEnd = false;
  run = 0;
  dir = "";
  outdir = "";
  fFilename = "";
};

void RunGlue::Clean() {
  if ( !merged ) gSystem->Unlink(fFilename);
  lList->Delete();
  delete Target;
};

void RunGlue::SetDebug(Bool_t dbg) {
  fDBG = dbg;
};

void RunGlue::SetDList(TString list) {
  //
  RUN = true;
  //
  if (list.Contains("-RUN", TString::kIgnoreCase)) RUN = false;
  if (list.Contains("-ALL", TString::kIgnoreCase)) RUN = false;
  if (list.Contains("+RUN", TString::kIgnoreCase)) RUN = true;
  if (list.Contains("+ALL", TString::kIgnoreCase)) RUN = true;
  //
  fDList = list;
  //  li->SetWhichTrees(fDList);
  //
  if ( DebugMode() ) printf(" Detector list is %s \n",fDList.Data());
  //
};

TList *RunGlue::GetRunList(){
  //  
  lList = new TList();
  lList->Clear();
  TString thisrun;
  TFile *su;
  //
  TSQLResult *pResult;
  TSQLRow *Row;
  //
  if ( run && runmode ){
    //
    // Qurey the GL_RUN table to obtain RUN infos
    //
    GL_RUN *glrun = new GL_RUN();
    glrun->Query_GL_RUN(run,dbc);
    //
    // convert RUNHEADER_TIME into a UTC date
    //
    GL_TIMESYNC *dbtime = new GL_TIMESYNC();
    //
    TString UTC="UTC";
    TString rhdate=dbtime->ConvertTime(UTC,glrun->RUNHEADER_TIME);
    //
    TDatime ti = TDatime(rhdate.Data());
    //
    YY=(UInt_t)ti.GetYear();
    MM=(UInt_t)ti.GetMonth();
    DD=(UInt_t)ti.GetDay();
    //
    TTimeStamp *llim = new TTimeStamp(YY,MM,DD,0,0,0,0,true,0);
    //
    UInt_t lowerlimit = llim->GetSec();
    UInt_t upperlimit = lowerlimit + 86401;
    //
    if ( DebugMode() ) printf(" YY %u MM %u DD %u ll %u ul %u \n",YY,MM,DD,lowerlimit,upperlimit);
    //
    YY -= 2000;
    stringstream tmpf;
    tmpf.str("");
    tmpf << "L2PAM";
    if ( YY < 10 ){
      tmpf<< "0" << YY;
    } else {
      tmpf<< YY;
    };
    if ( MM < 10 ){
      tmpf<< "0" << MM;
    } else {
      tmpf<< MM;
    };
    if ( DD < 10 ){
      tmpf << "0" << DD << ".root";
    } else {
      tmpf << DD << ".root";
    };
    TString fpath = "";
    if ( !strcmp(outdir,"") ){
      fpath="./";
    } else {
      fpath += outdir;
      fpath += "/";
    };
    //
    fFilename = fpath + tmpf.str().c_str(); 
    //
    printf(" Output filename is %s \n",fFilename.Data());
    //
    if ( !this->OpenFile() ){
         fEnd = true;
	 return(0);
    };
    //
    stringstream myquery;
    myquery.str("");
    myquery << "SELECT ID FROM GL_RUN WHERE RUNHEADER_TIME>=" << (UInt_t)lowerlimit
	    << " AND RUNHEADER_TIME<" << (UInt_t)upperlimit << " ORDER BY RUNHEADER_TIME ASC;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    for( UInt_t r=0; r < 1000; r++){ 
      Row = pResult->Next();      
      if( Row == NULL ) break;
      if ( DebugMode() ) printf(" %u RUN %s \n",r,Row->GetField(0));
      //
      thisrun=dir+(TString)Row->GetField(0)+".Level2.root";      
      //
      if ( DebugMode() ) printf(" Filename is %s \n",thisrun.Data());
      //
      su = TFile::Open(thisrun);
      if ( li->CheckLevel2File(thisrun) ){
	lList->Add(su);
      } else {
		if ( DebugMode() ) printf(" RUN %s DISCARDED \n",Row->GetField(0));
      };
      //
    };
    //
    //
    delete glrun;
    delete dbtime;
    //
  };
  //
  if ( strcmp(dir.Data(),"" )){
    //
    if ( createlist ){
      fList = new TList();
      fDoneList = new TList();
      fNlist = 0;
      fNlistdone = 0;
      //
      // read files in the directory
      //
      if ( DebugMode() ) printf("\n No input run given\n Check for existing root files. \n");
      //    
      TSystemDirectory *datadir = new TSystemDirectory(gSystem->BaseName(dir),dir);
      TList *temp = datadir->GetListOfFiles();
      //
      TIter next(temp);
      TSystemFile *questo = 0;
      //
      while ( (questo = (TSystemFile*)next()) ) {
	TString name =  questo->GetName();
	if( name.EndsWith(".Level2.root") ){
	  char *fullpath0;
	  gSystem->IsFileInIncludePath(name,&fullpath0);
	  TString fullpath = fullpath0;
	  //
	  if ( DebugMode() ) printf(" fullpath = %s     name %s \n",fullpath.Data(),name.Data());
	  //
	  //
	  su = TFile::Open(fullpath);
	  if ( li->CheckLevel2File((TString)fullpath) ){
	    fList->Add(su);
	    fNlist++;
	  } else {
	    if ( DebugMode() ) printf(" RUN %s DISCARDED \n",fullpath.Data());
	  };
	  //
	};
      };
      createlist = false;
      nrun = 0;
    };
    //
    //
    //
    Bool_t stop = true;
    UInt_t drun = 0;
    while ( nrun < fNlist && stop ){
      TString myrun = (TString)((TString)(gSystem->BaseName(((TFile*)fList->At(nrun))->GetName()))).ReplaceAll(".Level2.root",12,"",0);
      if ( DebugMode() ) printf(" nrun %u myrun is %s \n",nrun,(myrun.ReplaceAll(".Level2.root",12,"",0)).Data());
      run = (UInt_t)(myrun.Atoi());
      nrun++;
      //
      TString donerun = "";
      for (UInt_t ll=0; ll<fNlistdone; ll++){	
	donerun = "";
	donerun = (TString)((TString)(gSystem->BaseName(((TFile*)fDoneList->At(ll))->GetName()))).ReplaceAll(".Level2.root",12,"",0);
	if ( DebugMode() ) printf(" donerun is %s \n",(donerun.ReplaceAll(".Level2.root",12,"",0)).Data());	
	drun = (UInt_t)(donerun.Atoi());
	//
	if ( run == drun ) goto jump;
	//
      };
      //
      stop = false;
      //
    jump:
      drun = 0;
      //
    };
    //
    if ( nrun >= fNlist && stop ){
      fEnd = true;
      return(0);
    };
    //
    // Qurey the GL_RUN table to obtain RUN infos
    //
    printf(" PROCESSING RUN %u AND ITS FRIENDS\n",run);
    GL_RUN *glrun = new GL_RUN();
    glrun->Query_GL_RUN(run,dbc);
    //
    // convert RUNHEADER_TIME into a UTC date
    //
    GL_TIMESYNC *dbtime = new GL_TIMESYNC();
    //
    TString UTC="UTC";
    TString rhdate=dbtime->ConvertTime(UTC,glrun->RUNHEADER_TIME);
    //
    TDatime ti = TDatime(rhdate.Data());
    //
    YY=(UInt_t)ti.GetYear();
    MM=(UInt_t)ti.GetMonth();
    DD=(UInt_t)ti.GetDay();
    //
    TTimeStamp *llim = new TTimeStamp(YY,MM,DD,0,0,0,0,true,0);
    //
    UInt_t lowerlimit = llim->GetSec();
    UInt_t upperlimit = lowerlimit + 86401;
    //
    if ( DebugMode() ) printf(" YY %u MM %u DD %u ll %u ul %u \n",YY,MM,DD,lowerlimit,upperlimit);
    //
    YY -= 2000;
    stringstream tmpf;
    tmpf.str("");
    tmpf << "L2PAM";
    if ( YY < 10 ){
      tmpf<< "0" << YY;
    } else {
      tmpf<< YY;
    };
    if ( MM < 10 ){
      tmpf<< "0" << MM;
    } else {
      tmpf<< MM;
    };
    if ( DD < 10 ){
      tmpf << "0" << DD << ".root";
    } else {
      tmpf << DD << ".root";
    };
    TString fpath = "";
    if ( !strcmp(outdir,"") ){
      fpath="./";
    } else {
      fpath += outdir;
      fpath += "/";
    };
    //
    fFilename = fpath + tmpf.str().c_str(); 
    //
    printf(" Output filename is %s \n",fFilename.Data());
    //
    if ( !this->OpenFile() ) return(0);
    //
    stringstream myquery;
    myquery.str("");
    myquery << "SELECT ID FROM GL_RUN WHERE RUNHEADER_TIME>=" << (UInt_t)lowerlimit
	    << " AND RUNHEADER_TIME<" << (UInt_t)upperlimit << " ORDER BY RUNHEADER_TIME ASC;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    for( UInt_t r=0; r < 1000; r++){ 
      Row = pResult->Next();      
      if( Row == NULL ) break;
      if ( DebugMode() ) printf(" %u RUN %s \n",r,Row->GetField(0));
      //
      thisrun=dir+(TString)Row->GetField(0)+".Level2.root";      
      //
      if ( DebugMode() ) printf(" Filename is %s \n",thisrun.Data());
      //
      su = TFile::Open(thisrun);
      if ( su ){
	TFile *su0 = TFile::Open(thisrun);
	fDoneList->Add(su0);
	fNlistdone++;
      };
      if ( li->CheckLevel2File(thisrun) ){
	lList->Add(su);
	if ( DebugMode() ) printf(" RUN %s ADDED \n",Row->GetField(0));
      } else {
	if ( DebugMode() ) printf(" RUN %s DISCARDED \n",Row->GetField(0));
      };
      //
    };
    //
    if ( DebugMode() ){
      UInt_t ll = 0;
      while ( (TFile*)lList->At(ll) ){
	TString donerun = "";
	donerun = (TString)((TString)(gSystem->BaseName(((TFile*)lList->At(ll))->GetName()))).ReplaceAll(".Level2.root",12,"",0);
	printf(" XXX file is %s \n",donerun.Data());      
	ll++;
	//
      };
    };
    //
    delete glrun;
    delete dbtime;
    //
  };
  //
  // is it the end?
  //
  if ( runmode ){
    fEnd = true;
  } else {
    //
    // did we use all the run in the directory? if so exit
    //
    if ( nrun >= fNlist ) fEnd = true;
  };
  //
  return(lList);
};

Bool_t RunGlue::OpenFile(){
  //
  fOpen = false;
  printf(" Check if output file already exists \n");
  ifstream myfile;
  myfile.open((this->GetFilename()).Data());
  if ( myfile ){
    //  Target = TFile::Open((this->GetFilename()).Data(), "READ" );
    //
    //  if ( Target ){ 
    //    Target->Close();
    myfile.close();
    printf("Error opening target file, %s  already exist!\n",(this->GetFilename()).Data());
    return(false);
  } else {
    //
    // try to lock tables and work on a db level to avoid multiple file simultaneous access
    //
    stringstream oss;
    //  
    if ( fUpgrade ){
      oss.str("");
      oss << "lock table GL_ROOT write;";
      TSQLResult *result = 0;
      TSQLRow *row = 0;
      result = dbc->Query(oss.str().c_str()); 
      oss.str("");
      oss << "select ID from GL_ROOT where NAME='" << ((TString)gSystem->BaseName(this->GetFilename())).Data() << "';";
      result = dbc->Query(oss.str().c_str()); 
      row = result->Next();
      if ( row ){
	printf("Error opening target file (does %s exist? already in the DB? are the permissions ok?)\n",(this->GetFilename()).Data());
	return(false); 
      } else {
	oss.str("");
	oss << "insert into GL_ROOT (PATH,NAME) values ('$PAM_L2','" << ((TString)gSystem->BaseName(this->GetFilename())).Data() << "');";      
	result = dbc->Query(oss.str().c_str()); 
      };
      oss.str("");
      oss << "unlock tables;";
      result = dbc->Query(oss.str().c_str()); 
    };
    //    Target = TFile::Open((this->GetFilename()).Data(), "RECREATE" );
    Target = TFile::Open((this->GetFilename()).Data(), "NEW" );    
    //    
    printf(" Output file does not exist, creating it\n");
    //
    Long64_t maxsize = 99900000000LL;  
    //
    if ( !Target || Target->IsZombie()) {
      printf("Error opening target file (does %s exist? are the permissions ok?)\n",(this->GetFilename()).Data());
      //      exit(1);
      return(false);
    }
    //
    Target->Write();
    //
    //fastMethod = kTRUE;
    fastMethod = kFALSE;
    //    
    //
    TTree::SetMaxTreeSize(maxsize);
    //    Target->SetCompressionLevel(2);
    Target->SetCompressionLevel(3);
    //Target->SetCompressionLevel(5);
    //
    fOpen = true;
    return(true);
    //
  };
  //
  return(true);
  //
};


void RunGlue::DeleteRunFiles(TList *dlist){
  //
  TString donerun = "";
  //
  printf(" Deleting runs: \n");
  //
  UInt_t ll = 0;
  //
  while ( (TFile*)dlist->At(ll) ){
    donerun = (TString)(((TFile*)dlist->At(ll))->GetName());
    gSystem->Unlink(donerun);
    printf(" Deleted file is %s \n",donerun.Data());      
    ll++;
    //
  };
};

void RunGlue::UpdateDB(TList *dlist){
  //
  TSQLResult *pResult;
  TSQLRow *Row;
  stringstream myquery;
  //
  TString donerun = "";
  //
  if ( DebugMode() ) printf(" Updating GL_RUN: \n");
  //
  UInt_t ll = 0;
  UInt_t idl2 = 0;
  UInt_t idr = 0;
  //
  //
  myquery.str("");
  myquery << "select ID from GL_RAW where NAME='level2 files';";
  if ( DebugMode() ) printf(" query is %s \n",myquery.str().c_str());
  //
  pResult = dbc->Query(myquery.str().c_str());
  if ( !pResult ){
    printf(" ERROR QUERYING ON DB!\n");
    return;
  };
  Row = pResult->Next();
  if( Row == NULL ){
    printf(" ERROR QUERYING THE DB!\n");
    return;
  } else {
    idr = (UInt_t)atoll(Row->GetField(0));
  };
  //
  myquery.str("");
  myquery << "select ID from GL_ROOT where NAME='" << ((TString)gSystem->BaseName(this->GetFilename())).Data() << "';";
  if ( DebugMode() ) printf(" query is %s \n",myquery.str().c_str());
  //
  pResult = dbc->Query(myquery.str().c_str());
  if ( !pResult ){
    printf(" ERROR WRITING ON DB!\n");
    return;
  };
  Row = pResult->Next();      
  if( Row == NULL ){
    printf(" ERROR QUERYING THE DB!\n");
    return;
  } else {
    idl2 = (UInt_t)atoll(Row->GetField(0));
  };
  myquery.str("");
  //  myquery << "insert into GL_ROOT (ID_RAW,PATH,NAME) values (" << idr << ",'" << outdir.Data() << "','" << ((TString)gSystem->BaseName(this->GetFilename())).Data() << "');";
  //  myquery << "insert into GL_ROOT (ID_RAW,PATH,NAME) values (" << idr << ",'$PAM_L2','" << ((TString)gSystem->BaseName(this->GetFilename())).Data() << "');";
  myquery << "update GL_ROOT set ID_RAW=" << idr << " where ID=" << idl2 << ";";
  if ( DebugMode() ) printf(" query is %s \n",myquery.str().c_str());
  //
  pResult = dbc->Query(myquery.str().c_str());
  if ( !pResult ){
    printf(" ERROR WRITING ON DB!\n");
    return;
  };
  //
  //
  //
  UInt_t drun = 0;
  //
  while ( (TFile*)dlist->At(ll) ){
    donerun = "";
    donerun = (TString)((TString)(gSystem->BaseName(((TFile*)dlist->At(ll))->GetName()))).ReplaceAll(".Level2.root",12,"",0);
    drun = (UInt_t)(donerun.Atoi());
    //
    if ( DebugMode() ) printf(" Run is %s \n",donerun.Data());      
    //
    myquery.str("");
    myquery << "update GL_RUN set ID_ROOT_L2=" << idl2 << " where ID=" << drun << ";";
    if ( DebugMode() ) printf(" query is %s \n",myquery.str().c_str());
    //
    pResult = dbc->Query(myquery.str().c_str());
    if ( !pResult ){
    printf(" ERROR WRITING ON DB!\n");
    return;
    };    
    //
    ll++;
    //
  };
};

//
// method stolen to ROOT's "hadd" and modified
//
void RunGlue::MergeRootfile(TList *sourcelist) {
  //
  merged = true;
  //
  //  if ( li ) li->Delete();
  PamLevel2 *nli = new PamLevel2(wd,sourcelist,fDList);
  nli->SetSELLI(2);
  //
  Target->cd();
  //
  nli->CreateCloneTrees(Target);
  ULong64_t nevents = nli->GetEntries();	
  printf(" NEVENTS %llu \n",nevents);
  for(ULong64_t iev=0; iev<nevents; iev++){
    nli->Clear();
    if( nli->GetEntry(iev) ){
      nli->FillCloneTrees();
    };
  };
  Target->cd();
  nli->WriteCloneTrees();
  printf("Written file %s \n",Target->GetName());
  //  Target->Write();
  //  TTree *slist = (TTree*)Target->Get("SelectionList");
  //  slist->Delete("all");
  Target->Close();

//   //
//   TDirectory *target = Target;
//   //
//   if ( DebugMode() ) printf("\nTarget path is: %s \n",target->GetPath());
//   //
//   TString path( (char*)strstr( target->GetPath(), ":" ) );
//   path.Remove(0,2);
//   //
//   TDirectory *first_source = (TDirectory*)sourcelist->First();
//   THashList allNames;
//   //
//   while ( first_source ){
//     //
//     TDirectory *current_sourcedir = first_source->GetDirectory(path);
//     //
//     if ( !current_sourcedir ){
//       first_source = (TDirectory*)sourcelist->After(first_source);
//       continue;
//     }
//     //
//     // loop over all keys in this directory
//     //
//     TChain *globChain = 0;    
//     TIter nextkey( current_sourcedir->GetListOfKeys() );
//     TKey *key = 0;
//     TKey *oldkey = 0;
//     TH1::AddDirectory(kFALSE); // gain time, do not add the objects in the list in memory
//     //
//     while ( (key = (TKey*)nextkey()) ) {
//       //
//       //      printf(" target ls \n");
//       //      Target->ls();
//       //
//       if ( current_sourcedir == target ) break;
//       //
//       if ( oldkey && !strcmp(oldkey->GetName(),key->GetName()) ) continue; //keep only the highest cycle number for each key
//       //
//       if ( allNames.FindObject(key->GetName()) ) continue;
//       //
//       if ( DebugMode() ) printf(" Key name is -%s- \n",key->GetName());
//       //
//       //
//       //
//       if ( !strcmp(key->GetName(),"Tracker") && !li->IsTRK2() && !li->IsTRK1() && !li->IsTRKh() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"Calorimeter") && !li->IsCAL2() && !li->IsCAL1() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"ToF") && !li->IsTOF() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"Trigger") && !li->IsTRG() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"Anticounter") && !li->IsAC() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"S4") && !li->IsS4() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"NeutronD") && !li->IsND() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"OrbitalInfo") && !li->IsORB() ) continue;
//       //
//       if ( !strcmp(key->GetName(),"Run") && !li->IsRUN() ) continue;
//       //
//       if ( strcmp(key->GetName(),"Calorimeter") && strcmp(key->GetName(),"Tracker") && strcmp(key->GetName(),"ToF") && strcmp(key->GetName(),"Trigger") && strcmp(key->GetName(),"Anticounter") && strcmp(key->GetName(),"S4") && strcmp(key->GetName(),"NeutronD") && strcmp(key->GetName(),"OrbitalInfo") && strcmp(key->GetName(),"Run") && strcmp(key->GetName(),"ProcessID0") ){
// 	if ( DebugMode() ) printf(" ERROR UNKNOWN KEY %s !\n",key->GetName());
// 	continue;
//       };
//       //
//       printf(" 1 \n");
//       allNames.Add(new TObjString(key->GetName()));
//       printf(" 2 \n");
//       //
//       // read object from first source file
//       //
//       current_sourcedir->cd();
//       TObject *obj = key->ReadObj();
//       printf(" 3 \n");
//       //
//       if ( obj->IsA()->InheritsFrom("TTree") ){
// 	//
//       	// loop over all source files create a chain of Trees "globChain"
// 	//
// 	TString obj_name;
// 	printf(" 4 \n");
// 	//
// 	if ( path.Length() ) {
// 	  obj_name = path + "/" + obj->GetName();
// 	} else {
// 	  obj_name = obj->GetName();
// 	};
// 	//
// 	globChain = new TChain(obj_name);
// 	//
// 	globChain->SetCacheSize(0);
// 	//
// 	printf(" 5 \n");
// 	globChain->Add(first_source->GetName());
// 	printf(" 6 \n");
// 	//
// 	TFile *nextsource = (TFile*)sourcelist->After( first_source );
// 	//
// 	while ( nextsource ) {     	  
// 	  //
// 	  //do not add to the list a file that does not contain this Tree
// 	  //
// 	  printf(" 7 \n");
// 	  TFile *curf = TFile::Open(nextsource->GetName());
// 	  //
// 	  if ( curf ) {
// 	    //
// 	    Bool_t mustAdd = kFALSE;
// 	    //
// 	    if (curf->FindKey(obj_name)) {
// 	      //
// 	      mustAdd = kTRUE;
// 	      //
// 	    } else {
// 	      //
// 	      //we could be more clever here. No need to import the object
// 	      //we are missing a function in TDirectory
// 	      //
// 	      TObject *aobj = curf->Get(obj_name);
// 	      //
// 	      if ( aobj ){
// 		mustAdd = kTRUE;
// 		delete aobj;
// 	      };
// 	    };
// 	    if (mustAdd) {
// 	      printf(" 8 \n");
// 	      globChain->Add(nextsource->GetName());
// 	      printf(" 9 \n");
// 	    };
// 	  };
// 	  delete curf;
// 	  nextsource = (TFile*)sourcelist->After(nextsource);
// 	};
// 	//
// 	printf(" 10 \n");	
// 	delete nextsource;
// 	printf(" 11 \n");
// 	//
//       } else {
// 	//
// 	// object is of no type that we know or can handle
// 	//
// 	if ( DebugMode() ) cout << "Unknown object type, name: " 
// 	     << obj->GetName() << " title: " << obj->GetTitle() << endl;
//       };
//       //
//       // now write the merged histogram (which is "in" obj) to the target file
//       // note that this will just store obj in the current directory level,
//       // which is not persistent until the complete directory itself is stored
//       // by "target->Write()" below
//       //
//       printf(" 12 \n");
//       if ( obj ){
// 	//
// 	target->cd();
// 	//
// 	if( obj->IsA()->InheritsFrom("TTree") ) {
// 	  //
// 	  Long64_t nfiles = 0;
// 	  if ( fastMethod ){
// 	    //	    globChain->Merge(target->GetFile(),0,"C keep fast");
// 	    nfiles=this->Mergy((TChain*)globChain,target->GetFile(),0,"C keep fast");
// 	  } else {
// 	    //globChain->Merge(target->GetFile(),0,"C keep");
// 	    printf(" 13 %llu \n",globChain->GetEntries());	    
// 	    nfiles=this->Mergy((TChain*)globChain,target->GetFile(),0,"C keep");
// 	    printf(" 14 \n");
// 	  };
// 	  //
// 	  merged = true;
// 	  //
// 	  if ( DebugMode() ){
// 	    printf(" Merged %i files\n",(int)nfiles);
// 	    globChain->ls();
// 	  };
// 	  //
// 	  delete globChain;
// 	  //	  return;
// 	  //
// 	} else {
// 	  //
// 	  //	  obj->Write( key->GetName() ); // <==================================================================================
// 	  //
// 	};
//       };
//       delete obj;
//       oldkey = key;
//     };
//     //
//     first_source = (TDirectory*)sourcelist->After(first_source);
//     //
//   };
//   // save modifications to target file
//   //
//   target->SaveSelf(kTRUE);
//   //
};


// Long64_t RunGlue::Mergy(TChain *mychain, TFile* file, Int_t basketsize, Option_t* option){
//    // We must have been passed a file, we will use it
//    // later to reset the compression level of the branches.
//    if (!file) {
//       // FIXME: We need an error message here.
//      printf(" 19 \n");
//      return 0;
//    }
//    printf(" 20 \n");

//    // Options
//    Bool_t fastClone = kFALSE;
//    TString opt = option;
//    opt.ToLower();
//    if (opt.Contains("fast")) {
//       fastClone = kTRUE;
//       printf(" 21 \n");
//    }
//    // The chain tree must have a list of branches
//    // because we may try to change their basket
//    // size later.
//    TObjArray* lbranches = mychain->GetListOfBranches();
//    if (!lbranches) {
//       // FIXME: We need an error message here.
//      printf(" 22 \n");
//       return 0;
//    }

//    //   file->cd();
//    // The chain must have a current tree because
//    // that is the one we will clone.
//    //   if (!fTree) {
//       // -- LoadTree() has not yet been called, no current tree.
//       // FIXME: We need an error message here.
//    //      return 0;
//    //   }

//    // Copy the chain's current tree without
//    // copying any entries, we will do that later.
//    printf(" 23 \n");
//    TTree* newTree = mychain->CloneTree(0);
//    if (!newTree) {
//       // FIXME: We need an error message here.
//      printf(" 24 \n");
//       return 0;
//    }
//    printf(" 25 \n");


//    // Strip out the (potential) directory name.
//    // FIXME: The merged chain may or may not have the
//    //        same name as the original chain.  This is
//    //        bad because the chain name determines the
//    //        names of the trees in the chain by default.
//    printf(" 26 \n");
//    newTree->SetName(gSystem->BaseName(mychain->GetName()));
//    printf(" 27 \n");

//    // FIXME: Why do we do this?
//    //   newTree->SetAutoSave(-1);
//    newTree->SetAutoSave(900000000000000LL);

//    printf(" 28 \n");
//    // Circularity is incompatible with merging, it may
//    // force us to throw away entries, which is not what
//    // we are supposed to do.
//    newTree->SetCircular(0);

//    // Reset the compression level of the branches.
//    if (opt.Contains("c")) {
//       TBranch* branch = 0;
//       TIter nextb(newTree->GetListOfBranches());
//       while ((branch = (TBranch*) nextb())) {
// 	printf(" 29 \n");
//          branch->SetCompressionLevel(file->GetCompressionLevel());
//       }
//    }

//    printf(" 30 \n");
//    // Reset the basket size of the branches.
//    if (basketsize > 1000) {
//       TBranch* branch = 0;
//       TIter nextb(newTree->GetListOfBranches());
//       while ((branch = (TBranch*) nextb())) {
// 	printf(" 31 \n");
//          branch->SetBasketSize(basketsize);
//       }
//    }

//    printf(" 32 \n");
//    Long64_t nentries = mychain->GetEntriesFast();
//    //Long64_t nentries = mychain->GetEntries();

//    // Copy the entries.
//    if (fastClone) {
//       // For each tree in the chain.
//       for (Long64_t i = 0; i < nentries; i += mychain->GetTree()->GetEntries()) {
//          if (mychain->LoadTree(i) < 0) {
//             break;
//          }
//          TTreeCloner cloner(mychain->GetTree(), newTree, option);
//          if (cloner.IsValid()) {
//             newTree->SetEntries(newTree->GetEntries() + mychain->GetTree()->GetEntries());
//             cloner.Exec();
//          } else {
//             if (mychain->GetFile()) {
// 	      printf("Merge Skipped file %s\n", mychain->GetFile()->GetName());
// 	       //            } else {
// 	       //               Warning("Merge", "Skipped file number %d\n", fTreeNumber);
//             }
//          }
//       }
//    } else {
//      printf(" 33 %llu \n",nentries);
//      mychain->Print();
//      for (Long64_t i = 0; i < nentries; i++) {
//        printf(" i %llu \n",i);
//        // for (Long64_t i = 0; i < 1; i++) {
//          if (mychain->GetEntry(i) <= 0) {
//             break;
//          }
//          newTree->Fill();
//       }
//       printf(" 34 \n");
//    }

//    // Write the new tree header.
//    printf(" 35 \n");
//    newTree->Write();

//    printf(" 36 \n");
//    // Get our return value.
//    Int_t nfiles = newTree->GetFileNumber() + 1;

//    // Close and delete the current file of the new tree.
//    if (!opt.Contains("keep")) {
//       // FIXME: What happens to fDirectory in newTree here?
//       delete newTree->GetCurrentFile();
//    }
//    return nfiles;
// }
