#ifndef runglue_h
#define runglue_h
//
#include <sstream>
#include <iostream>
#include <TFile.h>
#include <TTree.h>
#include <TTimeStamp.h>
#include <TTreeCloner.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TList.h>
#include <TString.h>
#include <TObject.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TString.h>
#include <TTimeStamp.h>
#include <TSQLServer.h>
#include <TRFIOFile.h>
#include <TSystem.h>
#include <TChain.h>
#include <TH1.h>
#include <TTree.h>
#include <TKey.h>
#include <Riostream.h>
#include <TObjString.h>
#include <TClass.h>
#include <PamLevel2.h>
//
/**
 * \brief Class to group runs day by day
 */
class RunGlue : public TObject {
 private:
    TSQLServer *dbc;
    PamLevel2 *li;
    UInt_t run;
    TString dir;
    TString outdir;
    TString fFilename;
    Bool_t fEnd;
    Bool_t RUN;
    TList *fDoneList;
    TList *fList;
    TList *lList;
    //    TFile *Target;
    TRFIOFile *Target;
    TFile *Source;
    TString fDList;
    Bool_t fastMethod;
    Bool_t fDBG;
    Bool_t fOpen;
    Bool_t castor;
    Bool_t runmode;
    Bool_t createlist;
    Bool_t merged;
    UInt_t fNlist;
    UInt_t fNlistdone;
    UInt_t nrun;
    UInt_t YY;
    UInt_t MM;
    UInt_t DD;

 public:
    //
    RunGlue();
    //
    RunGlue(TSQLServer *dbc,UInt_t run, TString dir, TString wrkdir, Bool_t castor);
    //
    // methods
    //
    void Clear();
    void Clean();
    TList *GetRunList();
    Long64_t Mergy(TChain *, TFile *, Int_t, Option_t *);
    //Long64_t Mergy(TChain *, TRFIOFile *, Int_t, Option_t *);
    void MergeRootfile(TList *);
    Bool_t OpenFile();
    //    Bool_t OpenFile(Bool_t castor);
    void SetDebug(Bool_t);
    void SetDList(TString);
    void DeleteRunFiles(TList *);
    void UpdateDB(TList *);
    //
    // inline methods
    //
    Bool_t End(){return(fEnd);};
    Bool_t FileIsOpen(){return(fOpen);};
    Bool_t DebugMode(){return(fDBG);};
    TString GetFilename(){return(fFilename);};
    //
    //
    //
    //
    ClassDef(RunGlue,1);
    //
};

#endif
