#ifndef CMDLINEPARSER_H
#define CMDLINEPARSER_H

#include <string>
#include <map>

#include "Options.h"

using std::string;
using std::map;

namespace FCUtils {

  typedef map<string,string> ArgMap;
  
  enum optmode {UPDATE,DEFINE};
  
  class CmdLineParser {
  public:
    
    CmdLineParser(): optmode_(DEFINE) {};
    CmdLineParser(int argc, char ** argv, optmode om=DEFINE): optmode_(om) 
    { ParseCmdLine(argc,argv);
    //    MoveToOptions();
    }
    
    void ParseCmdLine(int argc, char ** argv);
    void ParseCmdLineArg( string const &arg);
    void SetOptMode(optmode om){ optmode_=om; }
    optmode GetOptMode() const { return optmode_; }
    void MoveToOptions();
    void Print() const;
    
  private:
    ArgMap args_;
    optmode optmode_;
    
  }; // class CmdLineParser
  
}; // namespace FCUtils

#endif //CMDLINEPARSER_H
