#include <iostream>
#include "CmdLineParser.h"

namespace FCUtils {

  void CmdLineParser::ParseCmdLine(int argc, char ** argv) {
    int i=1;
    string arg,name,val;
    while( i < argc ) {
      // check for options starting with - or +
      arg=argv[i++];
      string::size_type p= arg.find_first_of("-",0,1);
      switch (p) {
      case 0:
	// If is an option add it to name and store the position to
	// save the val into
	name=arg.substr(1,arg.size()-1);
	// Let's start supposing is a boolean parameter
	args_[name]="true";
	break;
      case string::npos :
	// Here no - or + found, assign it to the latest saved
	// parameter
	args_[name]=arg;
	break;
      default:
	// put here an error message !
	break;
      }
    }
  }
  
  
  void CmdLineParser::MoveToOptions() {
    for (ArgMap::const_iterator i = args_.begin(); 
	 i != args_.end(); ++ i) {
      switch(optmode_) {
      case UPDATE:
	Options::Get()->UpdateOption(i->first, i->second);
	break;
      case DEFINE:
	Options::Get()->SetOption(i->first, i->second);
	break;
      default:
	break;
      }
    }
    
  }
  
  void CmdLineParser::Print() const {
    for (ArgMap::const_iterator i = args_.begin(); 
	 i != args_.end(); ++ i) {
      std::cout << " Arg : " <<  i->first 
		<<", value: " <<i->second << std::endl;
    }
  }
  
}; // namespace FCUtils
