#include <iostream>
#include <string>

#include "CmdLineParser.h"


using std::string;
using namespace FCUtils;

int main(int argc, char ** argv ){

  // A simple program to explain the usage of the CmdLineParser in
  // UPDATE mode, i.e. the options are defined in the main the command
  // line options are used just to update the default value used in
  // the definition

  // First of all get the singleton with the option map
  Options *provaopt=Options::Get();
  // Define the option. Set the option name, value and the help string
  // -file 
  provaopt->SetOption("file","nofile",
		      " -file filename, the name of the input file");
  // -test
  provaopt->SetOption("test","false"," -test test option");
  // -addtree
  provaopt->SetOption("addtree","true"," -addtree , add tree");
  // print the help 
  provaopt->Help();
  // print the values in the option map
  provaopt->Print();

  cout << endl << "++++++++ After CmdLineParser creation +++++++" << endl; 
  // Create the parser object in UPDATE mode, i.e. the options have
  // been definited already, the command line values will be used to
  // update the Options singleton
  CmdLineParser test(argc,argv,UPDATE);
  // Print the values as entered
  test.Print();
  // Move the entered values to the Options singleton
  test.MoveToOptions();

  // Print the help again
  provaopt->Help();
  // Print the values as entered by command line
  provaopt->Print();

  // Get the value from the option using various way

  // Use the GeOption methods of the Options class
  string ps;
  provaopt->GetOption("file") >> ps;
  std::cout << " The filename : " << ps << endl; 

  // Use the [] operator
  Options &popt=*Options::Get(); 
  popt["file"] >> ps;
  std::cout << " The filename : " << ps << endl; 
 
  return 0;


}
