#include <iostream>
#include <string>

#include "CmdLineParser.h"


using std::string;
using namespace FCUtils;

int main(int argc, char ** argv ){

  // A simple program to explain the usage of the CmdLineParser in
  // DEFINE mode, i.e. the options are not defined in the main. The command
  // line options them self are used to define and to update the value used in
  // the Options map singleton. Note that no help can be defined

  // First of all get the singleton with the option map
  Options *provaopt=Options::Get();
  // print the help. We are in DEFINE mode, no options have been
  // definited the Options singleton will be empty
  provaopt->Help();
  // print the values in the option map. Same as for the help
  provaopt->Print();

  cout << endl << "++++++++ After CmdLineParser creation +++++++" << endl; 
  // Create the parser object in DEFINE (default) mode, i.e. the
  // options will be definited reading them from the command line.
  CmdLineParser test(argc,argv);
  // Print the values as entered
  test.Print();
  // Move the entered values to the Options singleton
  test.MoveToOptions();

  // Print the help again
  provaopt->Help();
  // Print the values as entered by command line
  provaopt->Print();

  // Get the value from the option using various way

  // Use the GeOption methods of the Options class
  string ps;
  provaopt->GetOption("file") >> ps;
  std::cout << " The filename : " << ps << endl; 

  // Use the [] operator
  Options &popt=*Options::Get(); 
  popt["file"] >> ps;
  std::cout << " The filename : " << ps << endl; 
 
  return 0;


}
