#include "Options.h"

namespace FCUtils {

Options * Options::instance_=0;

Options::Options() { 
  // Set the error Option waiting for exceptions inplementation 
};

Options * Options::Get(){
  if(instance_==0) instance_=new Options();
  return instance_;
};

bool Options::IsOptionDef(string const &name) {
  return (GetOption(name).name!="error");
}

// Option const & Options::GetOption(string const &name){
//   OptMap::const_iterator it= options_.find(ToLower(name));
Option & Options::GetOption(string const &name){
  OptMap::iterator it= options_.find(ToLower(name));
  if(it== options_.end()) {
    cout << endl <<
      " --->>> Error in Options::GetOption , no option : "
      +name+" found !!!! " << endl;
    Help();
    exit(-1);
  } 
  return it->second;
}
  
bool Options::UpdateOption( const string &name, const string &val){    
  switch(IsOptionDef(name)){
  case true:
    options_[ToLower(name)].val=val;
    return true;
  default:
    return false;
  }
  return false;
}

void Options::Help() const {
  cout << endl << " Usage : " << endl;
  for( OptMap::const_iterator i=options_.begin(); i!=options_.end(); ++i) 
    i->second.Help();
  cout << endl << endl;
}
void Options::Print() const {
  for( OptMap::const_iterator i=options_.begin(); i!=options_.end(); ++i) 
    i->second.Print();
}

}; // namespace FCUtils
