//
// C/C++ headers
//
#include <fstream>
#include <string.h>
//
// ROOT headers
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayL.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TClonesArray.h>
//
// RunInfo header
//
#include <RunInfo.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <physics/trigger/TriggerEvent.h>
//
// This program headers
//
#include <TrigCore.h>
#include <TrigLevel2.h>
#include <TrigVerl2.h>
//
using namespace std;
//
//
// CORE ROUTINE
//
//
int TrigCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t Trigargc, char *Trigargv[]){
  //
  TString processFolder = Form("TrigFolder_%u",run);
  //
  // Set these to true to have a very verbose output.
  //
  Bool_t verbose = false;
  Bool_t debug = false;
  //
  if ( Trigargc > 0 ){
    Int_t i = 0;
    while ( i < Trigargc ){
      if ( !strcmp(Trigargv[i],"-processFolder") ) {
	if ( Trigargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)Trigargv[i+1];
	i++;
      };
      if ( !strcmp(Trigargv[i],"-v") ||  !strcmp(Trigargv[i],"--verbose") ) {
	verbose = true;
      };
      if ( !strcmp(Trigargv[i],"-g") ||  !strcmp(Trigargv[i],"--debug") ) {
	verbose = true;
	debug = true;
      };
      i++;
    };
  };
  //
  //
  // Output directory is the working directoy.
  //
  const char* outdir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  //
  // Variables for level2 
  //
  Long64_t maxsize = 10000000000LL;  
  TTree::SetMaxTreeSize(maxsize);
  //
  TTree *trigt = 0;
  UInt_t nevents = 0;
  //
  // variables needed to reprocess data
  //
  TString trigversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *trigtclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0;
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // trigger level2 classes
  //
  TrigLevel2 *trig = new TrigLevel2();
  TrigLevel2 *trigclone = new TrigLevel2();
  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  TBranch *l0head = 0;
  TBranch *l0trig = 0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  pamela::trigger::TriggerEvent *triggerEvent = 0;
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outdir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *temptrig = 0;
  stringstream tempname;
  stringstream Trigfolder;
  Bool_t myfold = false;
  tempname.str("");
  tempname << outdir;
  tempname << "/" << processFolder.Data();
  Trigfolder.str("");
  Trigfolder << tempname.str().c_str();
  tempname << "/trigtree_run";
  tempname << run << ".root";  
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  //
  // Let's start!
  //
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree Trigger already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 )  reproc = true;
  //
  //
  // Output file is "outputfile"
  //
  if ( !file->IsOpen() ){
    if ( verbose ) printf(" Trigger - ERROR: cannot open file for writing\n");
    throw -401;    
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  trigversion = TrigInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run,"TRIG",trigversion);
  if ( sgnl ){
    if ( verbose ) printf(" Trigger - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  UInt_t totnorun = runinfo->GetRunEntries();
  //
  // Try to access the Trigger tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  trigtclone = (TTree*)file->Get("Trigger");
  //
  if ( !trigtclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 && verbose ) printf(" Trigger - WARNING: you are reprocessing data but Trigger tree does not exist!\n");
    if ( runinfo->IsReprocessing() && run != 0 && verbose ) printf(" Trigger - WARNING: it seems you are not reprocessing data but Trigger\n versioning information already exists in RunInfo.\n");

  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    trigtclone->SetAutoSave(900000000000000LL);
    reproc = true;
    //
    // update versioning information
    //
    if ( verbose ) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 || totnorun == 1 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if ( verbose ) printf("\n Trigger - WARNING: Reprocessing all runs\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if ( verbose ) printf("\n Trigger - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      gSystem->MakeDirectory(Trigfolder.str().c_str());
      myfold = true;
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      temptrig = trigtclone->CloneTree(-1,"fast");
      temptrig->SetName("Trigger-old");
      tempfile->Write();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    trigtclone->Delete("all");
    //
    if ( verbose ) printf(" ...done!\n");
    //
  };
  //
  // create Trigger tree trigt
  // 
  file->cd();
  trigt = new TTree("Trigger-new","PAMELA Level2 Trigger data");
  trigt->SetAutoSave(900000000000000LL);
  trigt->Branch("TrigLevel2","TrigLevel2",&trig);
  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve alo tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    trigtclone = (TTree*)tempfile->Get("Trigger-old");
    trigtclone->SetAutoSave(900000000000000LL);
    trigtclone->SetBranchAddress("TrigLevel2",&trigclone);
    //      
    if ( nobefrun > 0 ){
      if ( verbose ) printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
      if ( verbose ) printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
      if ( verbose ) printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	trigtclone->GetEntry(j);	  
	//
	// copy trigclone to trig
	//
	//	trig = new TrigLevel2();
	trig->Clear();
	memcpy(&trig,&trigclone,sizeof(trigclone));
	//
	// Fill entry in the new tree
	//
	trigt->Fill();
	//
      };
      if ( verbose ) printf(" Finished successful copying!\n");
    };          
  };
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){
    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    idRun = runlist->At(irun);
    if ( verbose ) printf("\n\n\n ####################################################################### \n");
    if ( verbose ) printf("                    PROCESSING RUN NUMBER %u \n",idRun);
    if ( verbose ) printf(" ####################################################################### \n\n\n");
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( verbose ) printf(" Trigger - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_ROOT_L0
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( verbose ) printf("\n Trigger - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    TString host = glt->CGetHost();
    TString user = glt->CGetUser();
    TString psw = glt->CGetPsw();
    TSQLServer *dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
    if ( !dbc->IsConnected() ) throw -403;
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    //    if ( !dbc->IsConnected() ) throw -403;
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    //
    // print out informations
    //
    totevent = runinfo->NEVENTS;
    if ( verbose ) printf("\n LEVEL0 data file: %s \n",fname.Data());
    if ( verbose ) printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
    if ( verbose ) printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
    if ( verbose ) printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM,runinfo->EV_FROM+totevent);
    //
    // Open Level0 file
    //
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( verbose ) printf(" Trigger - ERROR: problems opening  Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( verbose ) printf(" Trigger - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( verbose ) printf(" Trigger - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0trig = l0tr->GetBranch("Trigger");
    if ( !l0trig ) {
      if ( verbose ) printf(" Trigger - ERROR: no Trigger branch in Level0 tree\n");
      l0File->Close();
      code = -402;
      goto closeandexit;
    };
    //
    l0tr->SetBranchAddress("Trigger", &triggerEvent);
    l0tr->SetBranchAddress("Header", &eh);
    //
    nevents = l0trig->GetEntries();
    //
    if ( nevents < 1 ) {
      if ( verbose ) printf(" Trigger - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    //
    if ( runinfo->EV_TO > nevents-1 ) {
      if ( verbose ) printf(" Trigger - ERROR: too few entries in the tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };
    //
    // run over all the events of the run
    //
    if ( verbose ) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    if ( dbc ){
      dbc->Close();
      delete dbc;
    };
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      //
      l0head->GetEntry(re);
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());  
      //
      // paranoid check
      //
      if ( atime > runinfo->RUNTRAILER_TIME || atime < runinfo->RUNHEADER_TIME  ) {
	if ( verbose ) printf(" Trigger - WARNING: event at time outside the run time window, skipping it\n");
	goto jumpev;
      };
      ///
      l0trig->GetEntry(re);
      ///
      //
      procev++;
      //
      // start processing
      //
      trig->Clear();
      //      trig = new TrigLevel2();
      //
      // now we must copy from the output structure to the level2 class:
      //
      trig->evcount = triggerEvent->evcount;
      for (Int_t kk=0; kk<3;kk++){
	trig->pmtpl[kk]  = triggerEvent->pmtpl[kk];
	trig->patternbusy[kk] = triggerEvent->patternbusy[kk];
      } 
      
      for (Int_t kk=0; kk<6;kk++){
	trig->trigrate[kk] = triggerEvent->trigrate[kk];
	trig->patterntrig[kk] = triggerEvent->patterntrig[kk];
      } 
      
      for (Int_t kk=0; kk<2;kk++){
	trig->dltime[kk] = triggerEvent->dltime[kk];
	trig->s4calcount[kk] = triggerEvent->s4calcount[kk];
      }
      
      for (Int_t kk=0; kk<24;kk++){
	trig->pmtcount1[kk] = triggerEvent->pmtcount1[kk];
	trig->pmtcount2[kk] = triggerEvent->pmtcount2[kk];
      }
      
      trig->trigconf = triggerEvent->trigconf;

      trig->unpackError = triggerEvent->unpackError;
      
      trigt->Fill();
      //    
      //
    jumpev:
      debug = false;
      //
    };
    //
    // Here you may want to clear some variables before processing another run  
    //
    delete dbtime;
  }; // process all the runs
  //
  if ( verbose ) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if ( verbose ) printf("\n Post-processing: copying events from the old tree after the processed run\n");   
      if ( verbose ) printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
      if ( verbose ) printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	trigtclone->GetEntry(j);
	//
	// copy trigclone to trig
	//
	trig->Clear();
	//
	memcpy(&trig,&trigclone,sizeof(trigclone));
	//
	// Fill entry in the new tree
	//
	trigt->Fill();
      };
      if ( verbose ) printf(" Finished successful copying!\n");
    };
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //
  if ( l0File ) l0File->Close();
  if ( tempfile ) tempfile->Close();            
  if ( myfold ) gSystem->Unlink(tempname.str().c_str());
  //
  if ( code < 0 && verbose ) printf("\n Trigger - ERROR: an error occurred, try to save anyway...\n");
  if ( verbose ) printf("\n Writing and closing rootple\n");
  if ( runinfo ) runinfo->Close();    
  if ( trigt ) trigt->SetName("Trigger");    
  if ( file ){
    file->cd();
    file->Write();
    //    file->Write("Trigger");
  };
  //
  if ( myfold ) gSystem->Unlink(Trigfolder.str().c_str());
  //
  // the end
  //
  if ( verbose ) printf("\n Exiting...\n");
  if ( trigt ) trigt->Delete();
  //
  if ( trig ) delete trig;
  if ( trigclone ) delete trigclone;
  if ( glroot ) delete glroot;
  if ( runinfo ) delete runinfo; 
  //
  if ( code < 0 ) throw code;
  return(code);
}



