
************************************************************

      subroutine readvkmask
            
      include 'commontracker.f'
      include 'calib.f'
      include 'common_c2f.f' !<<<< C2F

      c2f_error = 0 

c      if(C2F_DEBUG.eq.1)print *                   
      if(verbose)print *                   
     $     ,c2f_path(1:c2f_pathlen)//'trk-maskvk.dat' 
      open(10,
     $     FILE=c2f_path(1:c2f_pathlen)//'trk-maskvk.dat' !<<<< C2F
     $     ,STATUS='OLD'
     $     ,IOSTAT=iostat
     $     )
      if(iostat.ne.0)then
c         if(C2F_DEBUG.eq.1)
         if(debug)
     $        print*,'READVKMASK: *** Error opening file ***'
         c2f_error = 1
         return
      endif
      do iv=1,nviews
         read(10,*
     $        ,IOSTAT=iostat
     $        )
     $        (mask_vk(iv,i),i=1,24)
         if(iostat.ne.0)then
c            if(C2F_DEBUG.eq.1)
            if(debug)
     $           print*,'READVKMASK: *** Error reading file ***'
            c2f_error = 1
            goto 1000
         endif
      enddo
 1000 close(10)
 1001 continue     
      return 
      end


************************************************************

      subroutine readmipparam
            
      include 'commontracker.f'
      include 'calib.f'
      include 'common_c2f.f' !<<<< C2F

      character*60 fname_param 
      c2f_error = 0
 201  format('trk-LADDER',i1,'-mip.dat')
      do ilad=1,nladders_view         
         write(fname_param,201)ilad
c         if(C2F_DEBUG.eq.1)print *              
         if(VERBOSE)print *              
     $        ,c2f_path(1:c2f_pathlen)!<<<< C2F
     $        //fname_param(1:LNBLNK(fname_param))
         open(10,
     $        FILE=c2f_path(1:c2f_pathlen)!<<<< C2F
     $        //fname_param(1:LNBLNK(fname_param))
     $        ,STATUS='OLD'
     $        ,IOSTAT=iostat
     $        )
         if(iostat.ne.0)then
c            if(C2F_DEBUG.eq.1)print*
            if(DEBUG)print*
     $           ,'READMIPPARAM: *** Error opening file *** '
            c2f_error = 1
            return
         endif
         do iv=1,nviews
            read(10,*
     $           ,IOSTAT=iostat
     $           )pip,
     $            mip(int(pip),ilad)
            if(iostat.ne.0)then
               c2f_error = 1
               goto 1000
            endif
         enddo
 1000    close(10)
      enddo
      
	  return
      end
*** * * * *** * * * *** * * * *** * * * *** * * * *** * * * ***
      subroutine readchargeparam
      
      
      include 'commontracker.f'
      include 'calib.f'
      include 'common_c2f.f' !<<<< C2F
      character*60 fname_param 
	  c2f_error = 0
 201  format('charge-l',i1,'.dat')
      do ilad=1,nladders_view         
         write(fname_param,201)ilad
c         if(C2F_DEBUG.eq.1)print * 
         if(VERBOSE)print * 
     $        ,c2f_path(1:c2f_pathlen)!<<<< C2F
     $        //fname_param(1:LNBLNK(fname_param))
         open(10,
     $        FILE=c2f_path(1:c2f_pathlen)!<<<< C2F
     $        //fname_param(1:LNBLNK(fname_param))
     $        ,STATUS='OLD'
     $        ,IOSTAT=iostat
     $        )
         if(iostat.ne.0)then
            c2f_error = 1
            return
         endif
         do ip=1,nplanes
            read(10,*
     $           ,IOSTAT=iostat
     $           )pip,
     $            kch(ip,ilad),cch(ip,ilad),sch(ip,ilad)         
            if(iostat.ne.0)then
			   c2f_error = 1
               goto 1000
            endif
         enddo
 1000    close(10)
      enddo

      return
      end
*** * * * *** * * * *** * * * *** * * * *** * * * *** * * * ***
      subroutine readetaparam
*     -----------------------------------------
*     read eta2,3,4 calibration parameters
*     and fill variables:
*
*     eta2(netabin,nladders_view,nviews)
*     eta3(2*netabin,nladders_view,nviews)
*     eta4(2*netabin,nladders_view,nviews)
*
      include 'commontracker.f'
      include 'calib.f'
      include 'common_c2f.f' !<<<< C2F

      character*40 fname_binning
      character*40 fname_param
      
      
      c2f_error = 0
	  
******retrieve ANGULAR BINNING info
      fname_binning='binning.dat'
c      if(C2F_DEBUG.eq.1)
      if(VERBOSE)
     $     print *                   
     $     ,c2f_path(1:c2f_pathlen)     !<<<< C2F
     $     //fname_binning(1:LNBLNK(fname_binning))
      open(10,
     $     FILE=c2f_path(1:c2f_pathlen) !<<<< C2F
     $     //fname_binning(1:LNBLNK(fname_binning))
     $     ,STATUS='OLD'
     $     ,IOSTAT=iostat
     $     )
      if(iostat.ne.0)then
c         if(C2F_DEBUG.eq.1) 
         if(DEBUG) 
     $        print*,'READETAPARAM: *** Error in opening file *** '
         c2f_error = 1
         return
      endif
c      print*,'---- ANGULAR BINNING ----'
c      print*,'Bin   -   angL   -   angR'
 101  format(i2,'       ',f6.2,'     ',f6.2)
      xnn=0
      do ibin=1,nangmax
         read(10,*
     $        ,IOSTAT=iostat
     $        )xnn,angL(ibin),angR(ibin)
         if(iostat.ne.0)goto 1000
c         write(*,101)int(xnn),angL(ibin),angR(ibin)
      enddo         
 1000 nangbin=int(xnn)
      close(10)
      if(nangbin.eq.0)c2f_error = 1
c      print*,'-------------------------'
c      print*,nangbin
      


      do ieta=2,4               !loop on eta 2,3,4        
******retrieve correction parameters
 200     format(' Opening eta',i1,' files...')
c         if(C2F_DEBUG.eq.1)write(*,200)ieta
         if(VERBOSE)write(*,200)ieta

 201     format('eta',i1,'-bin',i1,'-l',i1,'.dat')
 202     format('eta',i1,'-bin',i2,'-l',i1,'.dat')
         do iang=1,nangbin
            do ilad=1,nladders_view
               if(iang.lt.10)write(fname_param,201)ieta,iang,ilad
               if(iang.ge.10)write(fname_param,202)ieta,iang,ilad
               open(10,
c     $              FILE=eta_parampath(1:eta_pathlen) !<<<< C2F
     $              FILE=c2f_path(1:c2f_pathlen) !<<<< C2F
     $              //fname_param(1:LNBLNK(fname_param))
     $              ,STATUS='OLD'
     $              ,IOSTAT=iostat
     $              )
               if(iostat.ne.0)then
c                  if(C2F_DEBUG.eq.1)
                  if(DEBUG)
     $                 print*,'READETAPARAM: ** Error opening file ** '
     $                 ,c2f_path(1:c2f_pathlen)
     $                 //fname_param(1:LNBLNK(fname_param))
                  c2f_error = 1
                  return
               endif
               netaval=0
               do ival=1,netavalmax
                  if(ieta.eq.2)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta2(ival,iang),
     $                 (feta2(ival,iv,ilad,iang),iv=1,nviews)
                  if(ieta.eq.3)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta3(ival,iang),
     $                 (feta3(ival,iv,ilad,iang),iv=1,nviews)
                  if(ieta.eq.4)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta4(ival,iang),
     $                 (feta4(ival,iv,ilad,iang),iv=1,nviews)
                  if(iostat.ne.0)then
                     if(netaval.eq.0)then
c                        if(C2F_DEBUG.eq.1)print*,'READETAPARAM: '
                        if(DEBUG)print*,'READETAPARAM: '
     $                       //'*** Error reading file *** '
     $                       ,c2f_path(1:c2f_pathlen)
     $                       //fname_param(1:LNBLNK(fname_param))
     $                       ,' (netaval=',netaval,')'
                        c2f_error = 1
                     endif
                     goto 2000
                  endif
                  netaval=netaval+1
               enddo
 2000          close(10)
*               print*,'... done'
            enddo
         enddo

      enddo                     !end loop on eta 2,3,4


      return
      end

*************************************************************************
      subroutine readalignparam

      include 'commontracker.f'
      include 'common_mech.f'
      include 'common_align.f'
      include 'common_c2f.f'

      character*50 fname_param
      integer sensor
c      character*120 cmd1
c      character*120 cmd2

	  c2f_error = 0
      call mech_sensor
      do ip=1,nplanes
        fitz(ip)=z_mech_sensor(ip,1,1)*0.1 !cm
*     gets planes mechanical z positions
*     (in mm) and sets them in micrometers
       enddo   

      
 100  format('parameters_l',i1,'s',i1,'.dat')

      do ilad=1,nladders_view
         do is=1,2

            write(fname_param,100)ilad,is
c            if(C2F_DEBUG.eq.1)print *
            if(VERBOSE)print *
     $           ,c2f_path(1:c2f_pathlen)
     $           //fname_param

            open(10,
     $           FILE=
     $           c2f_path(1:c2f_pathlen)
     $           //fname_param(1:LNBLNK(fname_param))
     $           ,STATUS='OLD',IOSTAT=iostat
     $           )
            if(iostat.ne.0)then
		         c2f_error = 1
                 return
            endif
            
            do ip=1,nplanes
*
*     NB! NB! NB! NB! NB!
*     The file labelled for example "l1s1" include the alignment
*     parameters of the column of sensors:
*
*     PLANE LADDER SENSOR
*     -------------------
*     1     1      2
*     2     1      1
*     3     1      1
*     4     1      1
*     5     1      1
*     6     1      1
*
*     This is becouse the plane 1 (bottom plane) is up-side-down
*
               sensor=is
               if(ip.eq.1)sensor=mod(is,2)+1 
               read(10,*)omega(ip,ilad,sensor)
               read(10,*)beta(ip,ilad,sensor)
               read(10,*)gamma(ip,ilad,sensor)
               
c     N.B. I convert angles from microradiants to radiant
               omega(ip,ilad,sensor)=omega(ip,ilad,sensor)/1.d6
               beta(ip,ilad,sensor)=beta(ip,ilad,sensor)/1.d6
               gamma(ip,ilad,sensor)=gamma(ip,ilad,sensor)/1.d6

               read(10,*)dx(ip,ilad,sensor)
               read(10,*)dy(ip,ilad,sensor)
               read(10,*)dz(ip,ilad,sensor)
            enddo
            
            close(10)
         enddo
      enddo
      
      return
      end

c------------------------------------------------------------------------

c     NB: le coordinate in mech_pos.dat sono calcolate a partire da alcuni dati
c     contenuti in commontracker.f. forse si puo' evitare mech_pos.dat e mettere
c     tutto in commontracker.f


      subroutine mech_sensor    
c     !it reads sensors coordinates (in PAMELA reference
c     ! frame) from a text file and it uses them to fill
c     ! x/y/z_mech_sensor variables, taking into account
c     ! last plane inversion

      include 'commontracker.f'
      include 'common_tracks.f'
      include 'common_c2f.f'

      real xvec(nladders_view),yvec(2),zvec(nplanes)

	  c2f_error = 0
	  
c      if(C2F_DEBUG.eq.1)print *
      if(VERBOSE)print *
     $     ,c2f_path(1:c2f_pathlen)//'mech_pos.dat'
      open(10
     $     ,FILE=
     $     c2f_path(1:c2f_pathlen)//'mech_pos.dat'
     $     ,IOSTAT=iostat) 
c     !sensors centres coordinates in mm in 
c     ! PAMELA reference frame:
c     ! the first plane is the one with lowest Z (the one
c     ! nearest the calorimeter)
c     ! the first ladder is the one with lowest X (the
c     ! one on which the first X strip is)
c     ! the first sensor is the one with lowest Y (the
c     ! one on which the first Y strip is) for planes
c     ! 2..6. for plane 1 the first sensor has higher Y
      
      if(iostat.ne.0)then
         c2f_error = 1
         return
      endif

      read(10,*) xvec
      read(10,*) yvec
      read(10,*) zvec

      do i=1,nplanes
        do j=1,nladders_view
          do k=1,2
            x_mech_sensor(i,j,k)=xvec(j)
            y_mech_sensor(i,j,k)=yvec(k)
            z_mech_sensor(i,j,k)=zvec(i)
            if(i.eq.1) then     !y coordinates of first plane (11th view) are
              y_mech_sensor(i,j,k)=-yvec(k) ! exchanged due to last plane inversion
            endif              
          enddo
        enddo
      enddo

      close(10)

                                ! *** INIZIO DEBUG ***
c$$$      do i=1,6
c$$$        do j=1,3
c$$$          do k=1,2
c$$$c            j=1
c$$$            print*,x_mech_sensor(i,j,k)
c$$$            print*,y_mech_sensor(i,j,k)
c$$$            print*,z_mech_sensor(i,j,k)
c$$$          enddo
c$$$        enddo
c$$$        print*,' '
c$$$      enddo
                                ! *** FINE DEBUG ***

      
      return
      end
c------------------------------------------------------------------------
      
