*************************************************************************
*     Program analysis.f
*
*     - reads cluster information (LEVEL1, reduction.f output ntuple)
*     - perform track identification and fit
*     - create LEVEL2 ntuple
*
*************************************************************************
      subroutine analysisflight

      include 'commontracker.f'
      include 'common_momanhough.f'
      include 'common_mech.f'
      include 'common_xyzPAM.f'
      include 'common_mini_2.f'
      include 'calib.f'
      include 'level1.f'
      include 'level2.f'

*     flag to chose PFA
      character*10 PFA
      common/FINALPFA/PFA

c      parameter (inf=1.e8)      !just a huge number...
        
*     external functions
      external npl
      external acoordsi,coordsi,nld,coord,dcoord

************************************************************
************************************************************
************************************************************
*
*     track analysis
*
************************************************************
************************************************************
************************************************************
      PFA='ETA'

      if(DEBUG)then
         print*,'----------------------------------'
         print*,'START... ',good1,nclstr1,nclstrmax_level2
      endif

*------------------------------------------------------
*     LEVEL2 N-TUPLE INITIALIZATIONS
      call init_level2
c      if(.not.good1)then
      if(good1.eq.0)then
         goto 8800              !fill nt-uple and go to next event
      endif
*------------------------------------------------------
      
*------------------------------------------------------
*     cut on maximum number of clusters
*------------------------------------------------------
      if(nclstr1.gt.nclstrmax_level2)then
         goto 8800              !fill nt-uple and go to next event
      endif
      
      do i=1,nclstr1
         cl_used(i)=0           !init mask of clusters associated to a track
      enddo
      
      if(DEBUG)then
         print*,'----------------------------------'
         print*,iev,'   ** ',nev2
      endif

*     ///////////////////////////////////////////////
*     \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

      iflag=0
      call track_finding(iflag)
      if(iflag.eq.1)then        !bad event
         goto 880               !fill ntp and go to next event     
      endif 

      iflag=0
      call track_fitting(iflag)
      if(iflag.eq.1)then        !bad event
         goto 880               !fill ntp and go to next event     
      endif 
      


 880  continue

*     **********************************************************
*     stores info about clusters not associated with any track
*     **********************************************************

      call fill_level2_siglets
      
      if(DEBUG)then
            
         print*,''
         print*,'DONE!'
         print*,''
         print*,'* summary *'
         print*,'tracks    ',ntrk
         print*,'cl used   ',(cl_used(i),i=1,nclstr1)
         print*,''
         print*,''
      endif
      
 8800 continue
      
      
*     ///////////////////////////////////////////////
*     \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

 100  continue
      
      return
      end
      

************************************************************


